/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.sampler;

import com.jrockit.mc.flightrecorder.spi.IRange;

public class SampleInfo {
    private double[] m_totalValue;
    private double[] m_maxValue;
    private IRange[] m_maxRange;
    private IRange m_range;
    private boolean m_structuralDirty = true;

    public SampleInfo(int size) {
        this.init(size);
    }

    public void setStructuralDirty(boolean dirty) {
        this.m_structuralDirty = dirty;
    }

    public boolean isStructuralDirty() {
        return this.m_structuralDirty;
    }

    public void setSize(int size) {
        if (size != this.getSize()) {
            this.init(size);
        } else {
            this.clear();
        }
    }

    private void init(int size) {
        this.m_totalValue = new double[size];
        this.m_maxValue = new double[size];
        this.m_maxRange = new IRange[size];
    }

    public int getSize() {
        return this.m_totalValue.length;
    }

    public double[] getMaxValues() {
        return this.m_maxValue;
    }

    public IRange[] getMaxRanges() {
        return this.m_maxRange;
    }

    public double[] getTotal() {
        return this.m_totalValue;
    }

    public void clear() {
        int n = 0;
        while (n < this.m_totalValue.length) {
            this.m_totalValue[n] = 0.0;
            this.m_maxValue[n] = 0.0;
            this.m_maxRange[n] = null;
            ++n;
        }
    }

    public void addSample(int slot, double value, IRange range) {
        int n = slot;
        this.m_totalValue[n] = this.m_totalValue[n] + value;
        if (this.m_maxValue[slot] <= value) {
            this.m_maxRange[slot] = range;
            this.m_maxValue[slot] = value;
        }
    }

    public void setRange(IRange range) {
        this.m_range = range;
    }

    public IRange getRange() {
        return this.m_range;
    }
}

