/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.sampler;

import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import com.jrockit.mc.flightrecorder.ui.sampler.SampleInfo;
import java.util.ArrayList;
import java.util.Collection;

public class CompositeRangeSampler
implements ISampler {
    private final SampleInfo m_sampleInfo = new SampleInfo(0);
    private final ArrayList m_components = new ArrayList();

    public boolean needsStructuralRefresh(IRange range, int width) {
        if (this.m_sampleInfo.isStructuralDirty()) {
            return true;
        }
        for (ISampler sampleComponent : this.getComponents()) {
            if (!sampleComponent.needsStructuralRefresh(range, width)) continue;
            return true;
        }
        return this.m_sampleInfo.getSize() != width || !range.equals(this.m_sampleInfo.getRange());
    }

    public void add(ISampler sampleComponent) {
        this.m_components.add(sampleComponent);
    }

    public void addAll(Collection sampleComponents) {
        this.m_components.addAll(sampleComponents);
    }

    public void remove(ISampler sampleComponent) {
        this.m_components.remove(sampleComponent);
    }

    public void setInput(Object input) {
    }

    public void clear() {
        this.m_components.clear();
    }

    public SampleInfo getSampleInfo() {
        return this.m_sampleInfo;
    }

    public void sample(IRangeFilter filter) {
        int size = this.m_sampleInfo.getSize();
        for (ISampler sampleComponent : this.getComponents()) {
            if (sampleComponent.needsStructuralRefresh(this.getSampleInfo().getRange(), this.getSampleInfo().getSize())) {
                sampleComponent.getSampleInfo().setRange(this.getSampleInfo().getRange());
                sampleComponent.getSampleInfo().setSize(this.getSampleInfo().getSize());
                sampleComponent.getSampleInfo().clear();
                sampleComponent.sample(filter);
                sampleComponent.getSampleInfo().setStructuralDirty(false);
            }
            double[] totals = sampleComponent.getSampleInfo().getTotal();
            IRange[] maxRanges = sampleComponent.getSampleInfo().getMaxRanges();
            int m = 0;
            while (m < size) {
                this.getSampleInfo().addSample(m, totals[m], maxRanges[m]);
                ++m;
            }
        }
        this.getSampleInfo().setStructuralDirty(false);
    }

    public Collection getComponents() {
        return this.m_components;
    }
}

