/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.preferences;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench m_workbench;
    public static final String P_OPEN_CONTROL_PANEL_ON_RECORDING_START = "flightRecorder.openControlPanelOnRecordingStart";
    public static final String P_CLOSE_CONTROL_PANEL_ON_RECORDING_END = "flightRecorder.closeControlPanelOnRecordingEnd";
    public static final String P_REMOVE_FINISHED_RECORDING = "flightRecorder.removeFinishedRecording";

    public GeneralPage() {
        this.setPreferenceStore(FlightRecorderUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFERENCES_GENERAL_SETTINGS_TEXT);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Button button = this.createClearButton(container);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        return container;
    }

    public void createFieldEditors() {
    }

    private Button createClearButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.PREFERENCES_CLEAR_USER_SETTINGS_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralPage.this.ensureAllEditorsClosed()) {
                    GeneralPage.this.showConfirmUserSettingReset();
                }
            }
        });
        return button;
    }

    private boolean ensureAllEditorsClosed() {
        IEditorReference[] iEditorReferenceArray = this.m_workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if ("flightRecordingEditor".equals(ref.getId())) {
                this.showMustCloseEditor();
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void showMustCloseEditor() {
        MessageBox messageBox = new MessageBox(this.getShell(), 2);
        messageBox.setMessage(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TITLE);
        messageBox.open();
    }

    private void showConfirmUserSettingReset() {
        MessageBox messageBox = new MessageBox(this.getShell(), 200);
        messageBox.setMessage(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TITLE);
        messageBox.setText(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TEXT);
        if (messageBox.open() == 64) {
            ComponentsPlugin.getDefault().getUserInterfaceRepository().clearUserSettings("flightRecordingEditor");
        }
    }

    public void init(IWorkbench workbench) {
        this.m_workbench = workbench;
    }
}

