/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.ui.DoubleFieldEditor;
import com.jrockit.mc.core.misc.ui.IntFieldEditor;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilter;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilterFactory;
import com.jrockit.mc.flightrecorder.ui.filtering.FilterPart;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.text.NumberFormat;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;

public class RandomFilterPart
extends FilterPart {
    private DoubleFieldEditor m_probabilityEditor;
    private IntFieldEditor m_seedEditor;

    protected RandomFilterPart() {
        super(Messages.PREFILTER_WIZARD_RANDOM_FILTER_TEXT, Messages.PREFILTER_WIZARD_RANDOM_KEEP_EVENTS_WITH_PROB_TEXT, 1);
    }

    protected void createFieldEditors() {
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.horizontalSpan = 2;
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText(this.getDescription());
        label.setLayoutData((Object)gd1);
        this.m_probabilityEditor = new DoubleFieldEditor("filter.random.probability", Messages.PREFILTER_WIZARD_RANDOM_FILTER_PROBABILITY_TEXT, this.getFieldEditorParent());
        this.m_probabilityEditor.setValidRange(0.0, 1.0);
        this.m_probabilityEditor.setStringValue(NumberFormat.getNumberInstance().format(0.5));
        this.m_probabilityEditor.setPage((DialogPage)this);
        this.addField((FieldEditor)this.m_probabilityEditor);
        this.m_seedEditor = new IntFieldEditor("filter.random.seed", Messages.PREFILTER_WIZARD_RANDOM_SEED_TEXT, this.getFieldEditorParent());
        this.m_seedEditor.setValidRange(0, 1000000);
        this.m_seedEditor.setStringValue(Integer.toString(4711));
        this.m_seedEditor.setPage((DialogPage)this);
        this.addField((FieldEditor)this.m_probabilityEditor);
    }

    public EventFilter createFilter() {
        if (this.m_probabilityEditor.isValid() && this.m_seedEditor.isValid()) {
            return EventFilterFactory.createRandomFilter(this.m_probabilityEditor.getDoubleValue(), this.m_seedEditor.getIntValue());
        }
        return null;
    }

    public Image getImage() {
        return CorePlugin.getDefault().getImage("data.gif");
    }

    public void setExpectedCount(long eventCount) {
        double prob = 1000000.0 / (double)eventCount;
        prob = Math.floor(100.0 * prob) / 100.0;
        prob = Math.max(prob, 0.001);
        prob = Math.min(prob, 0.5);
        this.m_probabilityEditor.setStringValue(NumberFormat.getNumberInstance().format(prob));
    }
}

