/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import com.jrockit.mc.core.ui.MasterDetailWizardPage;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilter;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilterFactory;
import com.jrockit.mc.flightrecorder.ui.filtering.EventTypeFilterPart;
import com.jrockit.mc.flightrecorder.ui.filtering.FilterPart;
import com.jrockit.mc.flightrecorder.ui.filtering.IControlStatus;
import com.jrockit.mc.flightrecorder.ui.filtering.RandomFilterPart;
import com.jrockit.mc.flightrecorder.ui.filtering.ThresholdFilterPart;
import com.jrockit.mc.flightrecorder.ui.filtering.TimeSpanFilterPart;
import com.jrockit.mc.flightrecorder.ui.filtering.ZipInspector;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.preferences.Initializer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipException;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.xml.sax.SAXException;

public class FlightRecorderLoadWizardPage
extends MasterDetailWizardPage
implements IControlStatus {
    private static final long UNINPSECTED = Long.MIN_VALUE;
    private Text m_text;
    private long m_expectedEventCount = Long.MIN_VALUE;
    private Label m_progressText;
    private boolean m_aborted;
    private RandomFilterPart m_randomFilterPart;
    private Composite m_filter;
    private FlightRecording m_recording;
    private File m_file;

    public FlightRecorderLoadWizardPage(File file, int eventCount, FlightRecording recording) {
        super("flightRecordingpreFiltering", Messages.PREFILTER_WIZARD_TITLE, FlightRecorderUI.getDefault().getMCImageDescriptor("filter_wiz.png"));
        this.setDescription(MessageFormat.format(Messages.PREFILTER_WIZARD_MESSAGE_TEXT, eventCount));
        this.m_recording = recording;
        this.m_file = file;
    }

    public void registerDetailParts() {
        ThresholdFilterPart thresholdFilterPart = new ThresholdFilterPart();
        thresholdFilterPart.setContainer((IPreferencePageContainer)this);
        EventTypeFilterPart eventTypeFilterPart = new EventTypeFilterPart(this.m_recording);
        eventTypeFilterPart.setContainer((IPreferencePageContainer)this);
        TimeSpanFilterPart timeFilterPart = new TimeSpanFilterPart(this.m_recording);
        timeFilterPart.setContainer((IPreferencePageContainer)this);
        this.m_randomFilterPart = new RandomFilterPart();
        this.m_randomFilterPart.setContainer((IPreferencePageContainer)this);
        this.addDetailPart(timeFilterPart);
        this.addDetailPart(this.m_randomFilterPart);
    }

    private long getMaxEventsBeforeWrning() {
        int i = this.getPreferenceStore().getInt("filter.events.before.showing.filter.dialog");
        if (i == 0) {
            return Initializer.MAX_EVENT_WITHOUT_ASKING;
        }
        return i;
    }

    public boolean isAbortable(boolean inProgress) {
        return !inProgress;
    }

    public boolean isInterruptible(boolean inProgress) {
        return inProgress;
    }

    public boolean isUsable() {
        return true;
    }

    public boolean isSkippable(boolean inProgress) {
        return !inProgress;
    }

    public boolean isContinuable(boolean inProgress) {
        return !inProgress;
    }

    public boolean autoStart() {
        if (this.m_expectedEventCount == Long.MIN_VALUE) {
            this.m_expectedEventCount = this.getExpectedSize();
            return this.m_expectedEventCount <= this.getMaxEventsBeforeWrning();
        }
        return true;
    }

    private EventFilter collectFilters() {
        Collection filterParts = this.getDetailParts();
        ArrayList<EventFilter> eventFilters = new ArrayList<EventFilter>();
        for (FilterPart p : filterParts) {
            EventFilter filter;
            if (!p.isEnabled() || (filter = p.createFilter()) == null) continue;
            eventFilters.add(filter);
        }
        if (eventFilters.isEmpty()) {
            return null;
        }
        if (eventFilters.size() == 1) {
            return (EventFilter)eventFilters.get(0);
        }
        EventFilter[] eventFilterArray = eventFilters.toArray(new EventFilter[eventFilters.size()]);
        return EventFilterFactory.createCompositeFilter(eventFilterArray);
    }

    private long getExpectedSize() {
        block21: {
            if (this.m_expectedEventCount == Long.MIN_VALUE) {
                this.m_expectedEventCount = -1L;
                ZipInspector zi = null;
                try {
                    try {
                        zi = new ZipInspector(this.m_file);
                        this.m_expectedEventCount = zi.getLatencyEventCountApproximation();
                        if (this.m_expectedEventCount > this.getMaxEventsBeforeWrning()) {
                            String s1 = this.createSizeWarningMessage();
                            this.setMessage(s1, 2);
                            if (this.m_filter != null && !this.m_filter.isDisposed()) {
                                GridData detailGridData = new GridData(4, 4, true, true);
                                this.m_filter.setLayoutData((Object)detailGridData);
                                this.m_filter.getParent().layout();
                            }
                        }
                        assert (this.m_randomFilterPart != null);
                        if (this.m_randomFilterPart != null) {
                            this.m_randomFilterPart.setExpectedCount(this.m_expectedEventCount);
                        }
                    }
                    catch (ZipException zipException) {
                        if (zi == null) break block21;
                        try {
                            zi.close();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (IOException iOException) {
                        if (zi == null) break block21;
                        try {
                            zi.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                finally {
                    if (zi != null) {
                        try {
                            zi.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return this.m_expectedEventCount;
    }

    private String createSizeWarningMessage() {
        String highPrec;
        String lowPrec = highPrec = Long.toString(this.m_expectedEventCount);
        if (highPrec.length() > 2) {
            lowPrec = highPrec.substring(0, 2);
            int n = 2;
            while (n < highPrec.length()) {
                lowPrec = String.valueOf(lowPrec) + "0";
                ++n;
            }
        }
        String approx = NumberFormat.getInstance().format(new Long(lowPrec));
        return MessageFormat.format(Messages.PREFILTER_WIZARD_LARGE_RECORDING_FOUND_TEXT, approx);
    }

    public Composite createClient(Composite parent) {
        this.m_filter = super.createClient(parent);
        GridData detailGridData = new GridData(4, 4, true, true);
        detailGridData.exclude = false;
        this.m_filter.setLayoutData((Object)detailGridData);
        GridData gridprogressText = new GridData(4, 4, true, false);
        this.m_progressText = new Label(parent, 0);
        this.m_progressText.setLayoutData((Object)gridprogressText);
        GridData gridDataLabel = new GridData(4, 1, true, false);
        gridDataLabel.horizontalSpan = 2;
        Label label = new Label(parent, 0);
        label.setText(Messages.PREFILTER_WIZARD_LOG_TEXT);
        label.setLayoutData((Object)gridDataLabel);
        GridData gridDataText = new GridData(4, 4, true, true);
        gridDataText.horizontalSpan = 2;
        this.m_text = new Text(parent, 2634);
        this.m_text.setLayoutData((Object)gridDataText);
        return this.m_filter;
    }

    public void writeLog(final String message) {
        if (message == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!FlightRecorderLoadWizardPage.this.m_text.isDisposed()) {
                    String text = FlightRecorderLoadWizardPage.this.m_text.getText();
                    text = String.valueOf(text) + message + Text.DELIMITER;
                    FlightRecorderLoadWizardPage.this.m_text.setText(text);
                }
            }
        });
    }

    public void writeProgress(final String message) {
        if (message == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!FlightRecorderLoadWizardPage.this.m_progressText.isDisposed()) {
                    FlightRecorderLoadWizardPage.this.m_progressText.setText(message);
                }
            }
        });
    }

    private void writeMessage(final String message, final int type) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                FlightRecorderLoadWizardPage.this.setMessage(message, type);
            }
        });
    }

    public IPreferenceStore getPreferenceStore() {
        return FlightRecorderUI.getDefault().getPreferenceStore();
    }

    public void writeError(String errorMessage) {
        this.writeMessage(errorMessage, 3);
    }

    public void writeWarning(String warningMessage) {
        this.writeMessage(warningMessage, 2);
    }

    public void writeException(Throwable throwable) {
        this.writeLog(throwable.getMessage());
        if (!(throwable instanceof SAXException)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            this.writeLog(sw.toString());
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object o = event.getElement();
        if (o instanceof FilterPart) {
            FilterPart p = (FilterPart)((Object)o);
            p.setEnabled(event.getChecked());
        }
    }

    public boolean isAborted() {
        return this.m_aborted;
    }

    public void abort() {
        this.m_aborted = true;
    }
}

