/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilter;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilterFactory;
import com.jrockit.mc.flightrecorder.ui.filtering.FilterPart;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EventTypeFilterPart
extends FilterPart {
    private CheckboxTableViewer m_viewer;
    private FlightRecording m_recording;

    public EventTypeFilterPart(FlightRecording recording) {
        super("Event Type Filter", "Select event types to keep.", 0);
        this.m_recording = recording;
    }

    public Image getImage() {
        return FlightRecorderUI.getDefault().getImage("event-general-16.png");
    }

    public EventFilter createFilter() {
        Object[] elements = this.m_viewer.getCheckedElements();
        if (elements != null && elements.length != 0) {
            IEventType[] eventTypes = new IEventType[elements.length];
            int n = 0;
            while (n < eventTypes.length) {
                eventTypes[n] = (IEventType)elements[n];
                ++n;
            }
            return EventFilterFactory.createEventTypeFilter(eventTypes, true);
        }
        return null;
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridData gd1 = new GridData(4, 4, false, true);
        Label label = new Label(composite, 64);
        label.setText(this.getDescription());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        this.m_viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2560);
        this.m_viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new EventTypeLabelProvider());
        this.m_viewer.setSorter(new ViewerSorter());
        this.m_viewer.getTable().setLayoutData((Object)gd2);
        composite.setLayout((Layout)new GridLayout());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.m_viewer.getInput() == null) {
            ArrayList eventTypeList = new ArrayList();
            Iterator it = this.m_recording.getEventTypeRepository().getProducers().iterator();
            while (it.hasNext()) {
                eventTypeList.addAll(((IProducer)it.next()).getEventTypes());
            }
            this.m_viewer.setInput(eventTypeList);
        }
    }

    protected static class EventTypeLabelProvider
    extends LabelProvider {
        protected EventTypeLabelProvider() {
        }

        public String getText(Object element) {
            IEventType eventType;
            if (element instanceof IEventType && (eventType = (IEventType)element).getName() != null) {
                return eventType.getName();
            }
            return null;
        }
    }
}

