/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class EventFilterFactory {
    public static EventFilter createThresholdFilter(long threshold) {
        return new ThresholdFilter(threshold);
    }

    public static EventFilter createTimeFilter(IRange range) {
        return new TimeSpanFilter(range);
    }

    public static EventFilter createEventTypeFilter(IEventType[] acceptventTypes, boolean acceptUnknown) {
        return new EventTypeFilter(acceptventTypes, acceptUnknown);
    }

    public static EventFilter createCompositeFilter(EventFilter[] children) {
        return new CompositeFilter(children);
    }

    public static IRangeFilter createRangeFilter(final EventFilter filter) {
        return new IRangeFilter(){

            public boolean accept(IRange range) {
                return filter.accept((IEvent)range);
            }
        };
    }

    public static EventFilter createEventFilter(final IRangeFilter filter) {
        return new EventFilter(){

            public boolean accept(IEvent event) {
                return filter.accept((IRange)event);
            }
        };
    }

    public static EventFilter createRandomFilter(double probability, int seed) {
        return new RandomFilter(probability, seed);
    }

    private static final class CompositeFilter
    implements EventFilter {
        private final EventFilter[] m_childrenFilter;

        CompositeFilter(EventFilter[] childrenFilter) {
            this.m_childrenFilter = childrenFilter;
        }

        public boolean accept(IEvent event) {
            int n = 0;
            while (n < this.m_childrenFilter.length) {
                if (this.m_childrenFilter[n].accept(event)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    private static final class EventTypeFilter
    implements EventFilter {
        private final Set<IEventType> m_acceptDescriptionObject = new HashSet<IEventType>();

        public EventTypeFilter(IEventType[] keepEventTypes, boolean acceptUnknown) {
            this.m_acceptDescriptionObject.addAll((Collection<IEventType>)Arrays.asList(keepEventTypes));
        }

        public boolean accept(IEvent event) {
            return this.m_acceptDescriptionObject.contains(event.getEventType());
        }
    }

    private static final class RandomFilter
    implements EventFilter {
        private final Random m_randomGenerator;
        private final int m_probability;

        public RandomFilter(double probability, long seed) {
            this.m_randomGenerator = new Random(seed);
            this.m_probability = (int)(1000000.0 * probability + 0.5);
        }

        public boolean accept(IEvent event) {
            return this.m_randomGenerator.nextInt(1000000) < this.m_probability;
        }
    }

    private static final class ThresholdFilter
    implements EventFilter {
        private final long m_threshold;

        public ThresholdFilter(long threshold) {
            this.m_threshold = threshold;
        }

        public boolean accept(IEvent event) {
            return event.getDuration() > this.m_threshold;
        }
    }

    private static final class TimeSpanFilter
    implements EventFilter {
        private final IRange m_range;

        public TimeSpanFilter(IRange range) {
            this.m_range = range;
        }

        public boolean accept(IEvent event) {
            return event.getStartTimestamp() >= this.m_range.getStartTimestamp() && event.getEndTimestamp() <= this.m_range.getEndTimestamp();
        }
    }
}

