/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.selection;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventTypeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EnterEventTypeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EventTypeWizard
extends WizardPage
implements IPerformFinishable {
    private final Field[] FIELD = new Field[]{EventTypeDescriptorContentProvider.FIELD_NAME, EventTypeDescriptorContentProvider.FIELD_IDENTIFIER};
    private final EventTypeDescriptorRepository m_eventTypeRepository;
    private Button m_removeButton;
    private StructuredViewer m_viewer;
    private Button m_editButton;
    private IServiceLocator m_serviceLocator;

    public EventTypeWizard(EventTypeDescriptorRepository set, IServiceLocator serviceLocator) {
        super("eventTypeWizard");
        this.setMessage(Messages.DATA_SOURCE_WIZARD_MESSAGE_TEXT);
        this.setTitle(Messages.DATA_SOURCE_WIZARD_TITLE_TEXT);
        this.m_eventTypeRepository = (EventTypeDescriptorRepository)PersistenceToolkit.createWorkingCopy((Object)set);
        this.m_serviceLocator = serviceLocator;
    }

    public boolean performFinish() {
        PersistenceToolkit.commit((Object)this.m_eventTypeRepository);
        return true;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_viewer = this.createViewer(container);
        this.m_viewer.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, true);
        Composite buttons = this.createButtons(container);
        buttons.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, true);
        gd3.horizontalSpan = 2;
        Button filterButton = this.createFilterButton(container);
        filterButton.setLayoutData((Object)gd3);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
    }

    private Button createFilterButton(Composite container) {
        final Button button = new Button(container, 32);
        button.setText(Messages.DATA_SOURCE_WIZARD_ALLOW_EVENT_TYPE_CONSTRAINT_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventTypeWizard.this.m_eventTypeRepository.setUserFilterConstrained(button.getSelection());
            }
        });
        button.setSelection(this.m_eventTypeRepository.getUserFilterConstrained());
        return button;
    }

    private Composite createButtons(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd0 = new GridData(4, 4, true, false);
        Button addButton = this.createAddButton(container);
        addButton.setLayoutData((Object)gd0);
        GridData gd1 = new GridData(4, 4, true, false);
        Button addAllButton = this.createAddAllButton(container);
        addAllButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Button addWildcardButton = this.createAddWildcardButton(container);
        addWildcardButton.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, false);
        this.m_editButton = this.createEditButton(container);
        this.m_editButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, false);
        this.m_removeButton = this.createRemoveButton(container);
        this.m_removeButton.setLayoutData((Object)gd4);
        container.setLayout((Layout)new GridLayout());
        this.updateButtons();
        return container;
    }

    private Button createAddAllButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText(Messages.DATA_SOURCE_WIZARD_ADD_ALL_EVENT_TYPES_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventTypeDescriptor etd = new EventTypeDescriptor();
                etd.setName(Messages.DATA_SOURCE_WIZARD_ALL_EVENT_TYPES_DESCRIPTION_TEXT);
                etd.setIdentifier("*");
                EventTypeWizard.this.m_eventTypeRepository.getDescriptors().add(etd);
                EventTypeWizard.this.refresh();
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.DATA_SOURCE_WIZARD_REMOVE_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EventTypeWizard.this.getViewer().getSelection();
                if (!selection.isEmpty()) {
                    EventTypeWizard.this.m_eventTypeRepository.getDescriptors().removeAll(selection.toList());
                    EventTypeWizard.this.refresh();
                }
            }
        });
        return button;
    }

    private Button createAddButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.DATA_SOURCE_WIZARD_BROWSE_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseForEventTypeWizard ssw = new BrowseForEventTypeWizard(EventTypeWizard.this.m_serviceLocator, null, false, 2);
                OnePageWizardDialog opwd = new OnePageWizardDialog(button.getShell(), (IWizardPage)ssw);
                opwd.setWidthConstaint(800, Integer.MAX_VALUE);
                opwd.setHeightConstraint(400, 600);
                if (opwd.open() == 0) {
                    for (Object o : ssw.getSelection().toList()) {
                        if (!(o instanceof IEventType)) continue;
                        EventTypeWizard.this.m_eventTypeRepository.getDescriptors().add(EventTypeWizard.this.createEventTypeDescriptor((IEventType)o));
                    }
                    EventTypeWizard.this.refresh();
                }
            }
        });
        return button;
    }

    private EventTypeDescriptor createEventTypeDescriptor(IEventType type) {
        EventTypeDescriptor eventTypeDescriptor = new EventTypeDescriptor();
        eventTypeDescriptor.setName(type.getName());
        eventTypeDescriptor.setIdentifier(type.getPath());
        return eventTypeDescriptor;
    }

    private boolean edit(Shell shell, EventTypeDescriptor eventTypeDescriptor) {
        EnterEventTypeWizard wsw = new EnterEventTypeWizard(eventTypeDescriptor);
        OnePageWizardDialog opwd = new OnePageWizardDialog(shell, (IWizardPage)wsw);
        return opwd.open() == 0;
    }

    private Button createAddWildcardButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.DATA_SOURCE_WIZARD_ENTER_EVENT_TYPE_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventTypeDescriptor etd = new EventTypeDescriptor();
                if (EventTypeWizard.this.edit(button.getShell(), etd)) {
                    EventTypeWizard.this.m_eventTypeRepository.getDescriptors().add(etd);
                    EventTypeWizard.this.refresh();
                }
            }
        });
        return button;
    }

    private Button createEditButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.DATA_SOURCE_WIZARD_EDIT_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventTypeWizard.this.edit(button.getShell(), EventTypeWizard.this.getSelected());
                EventTypeWizard.this.refresh();
            }
        });
        return button;
    }

    private void updateButtons() {
        this.updateButton(this.m_editButton);
        this.updateButton(this.m_removeButton);
    }

    private void updateButton(Button button) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(!this.getViewer().getSelection().isEmpty());
        }
    }

    private EventTypeDescriptor getSelected() {
        if (!this.getViewer().getSelection().isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            return (EventTypeDescriptor)selection.getFirstElement();
        }
        return null;
    }

    private FieldTableViewer createViewer(Composite parent) {
        FieldTableViewer viewer = FieldTableViewer.createWithStandardTable((Composite)parent, (Field[])this.FIELD);
        viewer.setContentProvider((IContentProvider)new EventTypeDescriptorContentProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EventTypeWizard.this.updateButtons();
            }
        });
        viewer.setInput((Object)this.m_eventTypeRepository);
        return viewer;
    }

    private StructuredViewer getViewer() {
        return this.m_viewer;
    }

    private void refresh() {
        this.getViewer().refresh();
    }
}

