/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.selection;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.StringField;
import com.jrockit.mc.core.ui.fields.AbstractFieldTreeContentProvider;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeRepository;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;

final class EventTypeTreeContentProvider
extends AbstractFieldTreeContentProvider {
    private static int FIELD_COUNT = 0;
    public static final Field FIELD_NAME = new StringField(FIELD_COUNT++);
    public static final Field ATTRIBUTE = new StringField(FIELD_COUNT++);
    public static final Field CONTENT_TYPE = new StringField(FIELD_COUNT++);

    static {
        FIELD_NAME.setName(Messages.DATA_SOURCE_WIZARD_NAME_COLUMN_TEXT);
        FIELD_NAME.setWidthWeight(3);
        FIELD_NAME.setMinWidth(100);
        ATTRIBUTE.setName(Messages.DATA_SOURCE_IDENTIFIER_IDENTIFIER_COLUMN_TEXT);
        ATTRIBUTE.setWidthWeight(1);
        ATTRIBUTE.setMinWidth(100);
        CONTENT_TYPE.setName(Messages.DATA_SOURCE_WIZARD_CONTENT_TYPE_COLUMN_TEXT);
        CONTENT_TYPE.setWidthWeight(1);
        CONTENT_TYPE.setMinWidth(100);
    }

    EventTypeTreeContentProvider() {
    }

    protected Object[] getColumnObject(Object object) {
        Object[] result = new Object[FIELD_COUNT];
        if (object instanceof IRetriever) {
            IRetriever descriptor = (IRetriever)object;
            result[EventTypeTreeContentProvider.FIELD_NAME.INDEX] = descriptor.getName();
            result[EventTypeTreeContentProvider.ATTRIBUTE.INDEX] = descriptor.getAttributeIdentifier();
            result[EventTypeTreeContentProvider.CONTENT_TYPE.INDEX] = descriptor.getContentTypeString();
        }
        if (object instanceof IEventType) {
            IEventType type = (IEventType)object;
            result[EventTypeTreeContentProvider.FIELD_NAME.INDEX] = type.getName();
            result[EventTypeTreeContentProvider.ATTRIBUTE.INDEX] = "";
            result[EventTypeTreeContentProvider.CONTENT_TYPE.INDEX] = "";
        }
        return result;
    }

    protected Object[] getRowChildren(Object parentElement) {
        if (parentElement instanceof IEventTypeRepository) {
            IEventTypeRepository rep = (IEventTypeRepository)parentElement;
            return rep.asCollection().toArray();
        }
        if (parentElement instanceof EventTypeAcceptor) {
            EventTypeAcceptor eta = (EventTypeAcceptor)parentElement;
            return eta.getAcceptedSet().toArray();
        }
        if (parentElement instanceof IEventType) {
            IEventType type = (IEventType)parentElement;
            return type.getRetrivers().values().toArray();
        }
        return new Object[0];
    }

    protected Object[] getRowElements(Object inputElement) {
        return this.getRowChildren(inputElement);
    }

    protected boolean hasRowChildren(Object element) {
        return this.getRowChildren(element).length > 0;
    }
}

