/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.flightrecorder.ui.components.range.ComponentControl;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class ZoomOutControl
extends ComponentControl {
    private final JComponentNavigator m_navigator;
    private Image m_image;

    public ZoomOutControl(JComponentNavigator navigator) {
        super(Messages.NAVIGATOR_ZOOM_OUT_TEXT);
        this.setToolTip(Messages.NAVIGATOR_ZOOM_OUT_TEXT);
        this.m_image = CorePlugin.getDefault().getImage("zoom-out-16.png");
        this.m_navigator = navigator;
    }

    public boolean isEnabled() {
        return this.m_navigator.getViewportMax() < this.m_navigator.getWorldMax() || this.m_navigator.getViewportMin() > this.m_navigator.getWorldMin();
    }

    public void execute() {
        double viewPortMin = this.m_navigator.getViewportMin();
        double viewPortMax = this.m_navigator.getViewportMax();
        double width = viewPortMax - viewPortMin;
        viewPortMin = Math.max(this.m_navigator.getWorldMin(), viewPortMin - width);
        viewPortMax = Math.min(this.m_navigator.getWorldMax(), viewPortMax + width);
        this.m_navigator.setViewport(viewPortMin, viewPortMax);
    }

    public Image getImage() {
        return CorePlugin.getDefault().getImage("zoom-out-16.png");
    }

    public Point getPreferredPosition(Rectangle clientArea) {
        return new Point(clientArea.x + (clientArea.width - 3 * this.m_image.getBounds().width) / 2, clientArea.y + clientArea.height - this.m_image.getBounds().height - IMAGE_PAD);
    }
}

