/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.flightrecorder.ui.components.range.ComponentControl;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class ZoomInControl
extends ComponentControl {
    private static final int MINIMUM_ZOOM_IN_WIDTH = 10;
    private final JComponentNavigator m_navigator;
    private Image m_image;

    public ZoomInControl(JComponentNavigator navigator) {
        super(Messages.NAVIGATOR_ZOOM_IN_TEXT);
        this.setToolTip(Messages.NAVIGATOR_ZOOM_IN_TEXT);
        this.m_image = CorePlugin.getDefault().getImage("zoom-in-16.png");
        this.m_navigator = navigator;
    }

    public boolean isEnabled() {
        return this.m_navigator.getWorldMax() - this.m_navigator.getWorldMin() > 10.0;
    }

    public void execute() {
        double viewPortMin = this.m_navigator.getSelectedMin();
        double viewPortMax = this.m_navigator.getSelectedMax();
        double width = viewPortMax - viewPortMin;
        if (width > 100.0) {
            this.m_navigator.setViewport(viewPortMin, viewPortMax);
        }
    }

    public Image getImage() {
        return this.m_image;
    }

    public Point getPreferredPosition(Rectangle clientArea) {
        return new Point(clientArea.x + (clientArea.width + 3 * this.m_image.getBounds().width) / 2, clientArea.y + clientArea.height - this.m_image.getBounds().height - IMAGE_PAD);
    }
}

