/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.range.ISynchronizable;
import com.jrockit.mc.flightrecorder.ui.components.range.NavigatorListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeController
implements NavigatorListener {
    private static final String PROPERTY_NAVIGATOR_SYNCHRONIZATION = "navigator.synchronization";
    private final Object m_ignoree;
    private final UIScope m_UIScope;
    private IRange m_range;

    public RangeController(UIScope components, Object ignoree, IRange initialRange) {
        this.m_ignoree = ignoree;
        this.m_UIScope = components;
        this.m_range = initialRange;
    }

    @Override
    public void onNavigatorChange(Object source, double minX, double maxX) {
        this.sendRangeChange((IRange)new Range((long)minX, (long)maxX), this.m_UIScope.getAllComponents(INavigatorSelectionChangeListener.class));
    }

    public void setUseSynchronization(boolean use) {
        FlightRecorderUI.getDefault().getPreferenceStore().setValue(PROPERTY_NAVIGATOR_SYNCHRONIZATION, use);
        if (use) {
            this.sendRangeChange(this.m_range, this.m_UIScope.getTopScope().getCompatiblesWithChildren(INavigatorSelectionChangeListener.class));
        }
        for (ISynchronizable s : this.getScope().getTopScope().getCompatiblesWithChildren(ISynchronizable.class)) {
            s.synchronizationChange();
        }
    }

    public boolean getUseSynchronization() {
        return FlightRecorderUI.getDefault().getPreferenceStore().getBoolean(PROPERTY_NAVIGATOR_SYNCHRONIZATION);
    }

    public void setRange(IRange range, boolean broadcast) {
        this.m_range = range;
        if (broadcast) {
            if (this.getUseSynchronization()) {
                this.sendRangeChange(range, this.getScope().getTopScope().getCompatiblesWithChildren(INavigatorSelectionChangeListener.class));
            } else {
                this.sendRangeChange(range, this.getScope().getAllComponents(INavigatorSelectionChangeListener.class));
            }
        }
    }

    private void sendRangeChange(IRange range, List<INavigatorSelectionChangeListener> rangeListeners) {
        for (INavigatorSelectionChangeListener ircl : rangeListeners) {
            if (ircl == this.m_ignoree) continue;
            ircl.onChange(range.getStartTimestamp(), range.getEndTimestamp());
        }
    }

    private UIScope getScope() {
        return this.m_UIScope;
    }

    IRange getRange() {
        return this.m_range;
    }
}

