/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.core.misc.ui.ProgressCircle;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ProgressComponent
extends JComponent {
    private static final long serialVersionUID = -3477843728563083684L;
    private static final double ROTATION_TIME = 5000.0;
    private final long m_startTime = System.currentTimeMillis();
    private final ProgressCircle m_pc = new ProgressCircle();
    private BufferedImage m_image;
    private boolean m_inProgress = false;

    ProgressComponent() {
        this.m_pc.setInnerOuterRatio((double)0.85f);
        this.m_pc.setOpaque(false);
    }

    private void drawBackground(Graphics g) {
        if (this.m_image != null) {
            g.drawImage(this.m_image, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.m_image.getWidth(), this.m_image.getHeight(), null);
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintComponent(Graphics g) {
        this.drawBackground(g);
        if (this.isInProgress()) {
            this.drawProgressCircle(g);
        }
    }

    private void drawProgressCircle(Graphics g) {
        long diff = System.currentTimeMillis() - this.m_startTime;
        int angle = (int)Math.round(360.0 * (double)diff / 5000.0);
        this.m_pc.setSize(this.getWidth(), this.getHeight());
        this.m_pc.setAngle(angle);
        this.m_pc.paint(g);
    }

    public void setNewImage(BufferedImage image) {
        this.m_image = image;
    }

    public void setInProgress(boolean inProgress) {
        this.m_inProgress = inProgress;
    }

    public boolean isInProgress() {
        return this.m_inProgress;
    }
}

