/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.AccessibilityConstants;
import com.jrockit.mc.core.accessibility.AccessibilityToolkit;
import com.jrockit.mc.core.accessibility.MCAccessibleListener;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.chart.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.range.ISynchronizable;
import com.jrockit.mc.flightrecorder.ui.components.range.ImageBuilder;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.components.range.NavigatorListener;
import com.jrockit.mc.flightrecorder.ui.components.range.ProgressComponent;
import com.jrockit.mc.flightrecorder.ui.components.range.RangeController;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.legend.LegendViewer;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.impl.NanoTimestampFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Navigator
extends AbstractUIComponent
implements ITypeVisibilityChange,
INavigatorSelectionChangeListener,
IOperativeSetAware,
ISynchronizable {
    private static final int MINIMUM_DURATION = 1000;
    private static final double ZOOM_FACTOR = 2.0;
    private static final double TRANSLATION_FACTOR = 0.3;
    private final NanoTimestampFormatter m_startFormatter;
    private final NanoTimestampFormatter m_endFormatter;
    private RangeController m_rangeController;
    private ProgressComponent m_panel = new ProgressComponent();
    private double m_start;
    private double m_end;
    private Button m_translateBackButton;
    private Button m_translateForwardButton;
    private Label m_leftLabel;
    private Label m_rightLabel;
    private Button m_zoomOutButton;
    private Button m_zoomInButton;
    private JComponentNavigator m_navigator;
    private Button m_syncButton;
    private SelectionListener m_synchSelectionListener;
    private boolean m_typeChangedAllowed;

    public Navigator() {
        this.m_startFormatter = new NanoTimestampFormatter();
        this.m_startFormatter.setAlwaysShowDate(false);
        this.m_startFormatter.setTimeDateSeapator(" ");
        this.m_endFormatter = new NanoTimestampFormatter();
        this.m_endFormatter.setAlwaysShowDate(false);
        this.m_endFormatter.setTimeDateSeapator(" ");
    }

    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            ViewModelBuilder<BufferedImage> builder = this.createModelBuilder();
            builder.setEventView(this.createView());
            builder.setOperativeSetEnabled(false);
            serviceLocator.registerService(ViewModelBuilder.class.getName(), builder);
            serviceLocator.registerService((Object)new OperativeSetService());
            return true;
        }
        return false;
    }

    private IEventTypeView createView() {
        return this.getFlightRecording().createView();
    }

    private ViewModelBuilder<BufferedImage> createModelBuilder() {
        return new ImageBuilder(this.getServiceLocator(), this.getComponentDescriptor());
    }

    public Composite createPart(Composite parent) {
        Composite client = this.getFormToolkit().createComposite(parent);
        int columnCount = 2;
        client.setLayout((Layout)this.createClientLayout(columnCount));
        this.hookAccessibility(client);
        Range r = new Range(this.getStartService().getStartTimeStamp(), this.getStartService().getEndTimeStamp());
        this.m_rangeController = new RangeController(this.getComponents(), this, (IRange)r);
        this.m_start = this.getStartService().getStartTimeStamp();
        this.m_end = this.getStartService().getEndTimeStamp();
        GridData gd1 = new GridData(4, 4, true, false);
        LegendViewer lw = this.createLegendViewer(client, this.getFormToolkit());
        lw.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        this.m_syncButton = this.createSynchronizationButton(client);
        this.m_syncButton.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = columnCount;
        this.m_navigator = this.createNavigator(client);
        this.m_navigator.setLayoutData(gd3);
        this.getModelBuilder().setRange(this.getStartService().getStartTimeStamp(), this.getStartService().getEndTimeStamp());
        GridData gd4 = new GridData(4, 4, true, false);
        gd4.horizontalSpan = columnCount;
        Composite controlPanel = this.createControlPanel(this.getFormToolkit(), client);
        controlPanel.setLayoutData((Object)gd4);
        this.hookModelView();
        return client;
    }

    private Button createSynchronizationButton(Composite client) {
        final Button button = this.getFormToolkit().createButton(client, Messages.NAVIGATOR_SYNCHRONIZE_BUTTON_TEXT, 32);
        button.setSelection(this.m_rangeController.getUseSynchronization());
        this.m_synchSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.m_rangeController.setUseSynchronization(button.getSelection());
            }
        };
        button.addSelectionListener(this.m_synchSelectionListener);
        return button;
    }

    private GridLayout createClientLayout(int columnCount) {
        GridLayout l = new GridLayout();
        l.verticalSpacing = 2;
        l.marginHeight = 0;
        l.marginWidth = 0;
        l.numColumns = columnCount;
        return l;
    }

    private JComponentNavigator createNavigator(Composite client) {
        JComponentNavigator navigator = new JComponentNavigator(client, (FormToolkit)this.getServiceLocator().getService(FormToolkit.class), this.m_panel);
        navigator.setToolTipText(this.getComponentDescriptor().getDescription());
        navigator.setNavigatorRange(this.m_start, this.m_end);
        navigator.addSelectionListener(this.m_rangeController);
        navigator.addSelectionListener(new NavigatorListener(){

            public void onNavigatorChange(Object source, double minX, double maxX) {
                Navigator.this.update(minX, maxX, true);
            }
        });
        this.hoookResizeListener(navigator);
        return navigator;
    }

    private void hookAccessibility(Composite composite) {
        composite.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        MCAccessibleListener mc = new MCAccessibleListener();
        mc.setComponentType(AccessibilityConstants.COMPONENT_TYPE_NAVIGATOR);
        mc.setName("Time Selection");
        composite.getAccessible().addAccessibleListener((AccessibleListener)mc);
    }

    private void hoookResizeListener(JComponentNavigator navigator) {
        navigator.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int width = ((JComponentNavigator)((Object)e.getSource())).getClientArea().width;
                int height = ((JComponentNavigator)((Object)e.getSource())).getClientArea().height;
                Navigator.this.getModelBuilder().setSize(width, height);
                Navigator.this.markDirty();
            }
        });
    }

    private void hookModelView() {
        this.getModelBuilder().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Navigator.this.refreshInUIThread((BufferedImage)((ImageBuilder)o).getModel());
            }
        });
    }

    protected final void refreshInUIThread(final BufferedImage image) {
        DisplayToolkit.safeAsyncExec((Widget)this.m_navigator, (Runnable)new Runnable(){

            public void run() {
                if (!Navigator.this.m_navigator.isDisposed()) {
                    Navigator.this.m_panel.setNewImage(image);
                    Navigator.this.m_panel.setInProgress(false);
                    Navigator.this.m_navigator.invalidateNavigator(true);
                    Navigator.this.m_navigator.redraw();
                    Navigator.this.m_navigator.update();
                }
            }
        });
    }

    private LegendViewer createLegendViewer(Composite parent, FormToolkit formToolkit) {
        LegendViewer viewer = new LegendViewer(parent, formToolkit, 256);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider(this.getChartDescriptor(), parent.getDisplay(), 8));
        viewer.setInput((Object)this.getChartDescriptor().getLegendDescriptors());
        return viewer;
    }

    private ChartDescriptor getChartDescriptor() {
        return (ChartDescriptor)this.getComponentDescriptor().getComponentSettings().getChildObject("chartDescriptor", ChartDescriptor.class);
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    private Composite createControlPanel(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        this.m_leftLabel = this.createTimeLabel(toolkit, container, 16384);
        this.m_leftLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_leftLabel.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        this.m_translateBackButton = this.createTranslateBackward(container);
        this.m_translateBackButton.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.m_zoomOutButton = this.createZoomOut(container);
        this.m_zoomOutButton.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        GridData gd5 = new GridData(0x1000000, 4, false, false);
        this.m_zoomInButton = this.createZoomIn(container);
        this.m_zoomInButton.setLayoutData((Object)gd5);
        this.m_translateForwardButton = this.createTranslateForward(container);
        this.m_translateForwardButton.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.m_rightLabel = this.createTimeLabel(toolkit, container, 131072);
        this.m_rightLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_rightLabel.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        return container;
    }

    private Button createTranslateForward(Composite container) {
        Button button = new Button(container, 0);
        button.setImage(CorePlugin.getDefault().getImage("forward_nav.gif"));
        button.setToolTipText(Messages.NAVIGATOR_MOVE_FORWARD_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.updateIfValid(Navigator.this.translateRange(0.3));
                Navigator.this.updateSelectedArea();
            }
        });
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)button);
        return button;
    }

    private void updateIfValid(IRange range) {
        if (range != null) {
            this.update(range.getStartTimestamp(), range.getEndTimestamp(), true);
        }
    }

    private Button createTranslateBackward(Composite container) {
        Button button = new Button(container, 0);
        button.setImage(CorePlugin.getDefault().getImage("backward_nav.gif"));
        button.setToolTipText(Messages.NAVIGATOR_MOVE_BACKWARD_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.updateIfValid(Navigator.this.translateRange(-0.3));
                Navigator.this.updateSelectedArea();
            }
        });
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)button);
        return button;
    }

    private IRange translateRange(double factor) {
        IRange oldRange = this.m_rangeController.getRange();
        long duration = oldRange.getDuration();
        long translation = Math.round(factor * (double)duration);
        if (translation != 0L) {
            return new Range(oldRange.getStartTimestamp() + translation, oldRange.getEndTimestamp() + translation);
        }
        return null;
    }

    private void enableButton(Button button, boolean enabled) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    private Button createZoomIn(Composite container) {
        Button button = new Button(container, 0);
        button.setImage(CorePlugin.getDefault().getImage("zoom-in-16.png"));
        button.setToolTipText(Messages.NAVIGATOR_ZOOM_IN_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.updateIfValid(Navigator.this.zoomRange(2.0));
                Navigator.this.updateSelectedArea();
            }
        });
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)button);
        return button;
    }

    private void updateSelectedArea() {
        IRange r = this.m_rangeController.getRange();
        this.m_navigator.setSelectedAreaInWorldCoordinates(r.getStartTimestamp(), r.getEndTimestamp());
        this.m_navigator.redraw();
        this.m_navigator.update();
    }

    private IRange zoomRange(double factor) {
        long oldDuration;
        long newDuration;
        IRange oldRange = this.m_rangeController.getRange();
        if (oldRange == null) {
            oldRange = new Range((long)this.m_start, (long)this.m_end);
        }
        if ((newDuration = Math.round((double)(oldDuration = oldRange.getDuration()) / factor)) > 1000L) {
            long padding = (oldDuration - newDuration) / 2L;
            return new Range(oldRange.getStartTimestamp() + padding, oldRange.getEndTimestamp() - padding);
        }
        return null;
    }

    private Button createZoomOut(Composite container) {
        Button button = new Button(container, 0);
        button.setImage(CorePlugin.getDefault().getImage("zoom-out-16.png"));
        button.setToolTipText(Messages.NAVIGATOR_ZOOM_OUT_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Navigator.this.updateIfValid(Navigator.this.zoomRange(0.5));
                Navigator.this.updateSelectedArea();
            }
        });
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)button);
        return button;
    }

    private Label createTimeLabel(FormToolkit toolkit, Composite parent, int alignMent) {
        Label label = toolkit.createLabel(parent, "");
        label.setText("-- : -- : --");
        label.setAlignment(alignMent);
        return label;
    }

    @Override
    public void onChange(long startTime, long endTime) {
        double duration = this.m_end - this.m_start;
        if (duration > 0.0) {
            double startN = ((double)startTime - this.m_start) / (this.m_end - this.m_start);
            double endN = ((double)endTime - this.m_start) / (this.m_end - this.m_start);
            this.m_navigator.setSelectedArea(startN, endN);
            this.update(startTime, endTime, false);
            this.m_navigator.redraw();
            this.m_navigator.update();
        }
    }

    public void update(double startTime, double endTime, boolean broadcast) {
        double start = Math.max(startTime, this.m_start);
        double end = Math.min(this.m_end, endTime);
        long startL = Math.round(start);
        long endL = Math.round(end);
        this.enableButton(this.m_translateBackButton, start > (double)this.getStartService().getStartTimeStamp());
        this.enableButton(this.m_translateForwardButton, end < (double)this.getStartService().getEndTimeStamp());
        this.enableButton(this.m_zoomOutButton, start > (double)this.getStartService().getStartTimeStamp() || end < (double)this.getStartService().getEndTimeStamp());
        this.enableButton(this.m_zoomInButton, (double)(endL - startL) >= 2000.0);
        if (start == this.m_start) {
            this.setLabeltext(this.m_leftLabel, MessageFormat.format(Messages.NAVIGATOR_START_TIME_TEXT, this.m_startFormatter.format(startL, startL, endL)));
        } else {
            this.setLabeltext(this.m_leftLabel, MessageFormat.format(Messages.NAVIGATOR_SELECTED_START, this.m_startFormatter.format(startL, startL, endL)));
        }
        if (end == this.m_end) {
            this.setLabeltext(this.m_rightLabel, MessageFormat.format(Messages.NAVIGATOR_END_TIME_TEXT, this.m_endFormatter.format(endL, startL, endL)));
        } else {
            this.setLabeltext(this.m_rightLabel, MessageFormat.format(Messages.NAVIGATOR_SELECTED_END, this.m_endFormatter.format(endL, startL, endL)));
        }
        this.m_rangeController.setRange((IRange)new Range(startL, endL), broadcast);
    }

    private void updateSynchbutton() {
        if (this.m_syncButton != null && !this.m_syncButton.isDisposed()) {
            this.m_syncButton.removeSelectionListener(this.m_synchSelectionListener);
            this.m_syncButton.setSelection(this.m_rangeController.getUseSynchronization());
            this.m_syncButton.addSelectionListener(this.m_synchSelectionListener);
        }
    }

    private void setLabeltext(Label label, String text) {
        if (label != null && !label.isDisposed()) {
            label.setText(text);
        }
    }

    public void hide() {
    }

    protected OperativeSetService getOperativeSetService() {
        return (OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class);
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    public void initializeUI() {
        super.initializeUI();
        this.m_typeChangedAllowed = this.calcTypeChange();
        this.getModelBuilder().getView().setRange((IRange)new Range(this.getStartService().getStartTimeStamp(), this.getStartService().getEndTimeStamp()));
        this.getModelBuilder().fillProvider();
        this.getModelBuilder().updateChart();
    }

    private boolean calcTypeChange() {
        for (DataSeriesDescriptor ds : this.getChartDescriptor().getDataSeriesDescriptors()) {
            if (!FLRDescriptorToolkit.isUserFilterConstrained(ds)) continue;
            return true;
        }
        return false;
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    @Override
    public void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
        if (this.isUserFilterConstranied()) {
            this.markDirty();
        }
    }

    private boolean isUserFilterConstranied() {
        for (DataSeriesDescriptor dsd : this.getChartDescriptor().getDataSeriesDescriptors()) {
            if (!FLRDescriptorToolkit.isUserFilterConstrained(dsd)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        if (!this.m_navigator.isDisposed()) {
            if (!this.m_panel.isInProgress()) {
                this.m_panel.setInProgress(true);
                this.scheduleProgress();
            }
            this.m_navigator.invalidateNavigator(true);
            this.m_navigator.redraw();
            this.m_navigator.update();
            this.getModelBuilder().updateChart();
            this.getModelBuilder().scheduleRebuild();
            this.update(this.getStartService().getStartTimeStamp(), this.getStartService().getEndTimeStamp(), false);
        }
    }

    private void scheduleProgress() {
        DisplayToolkit.safeTimerExec((Widget)this.m_navigator, (int)50, (Runnable)new Runnable(){

            public void run() {
                if (Navigator.this.m_panel.isInProgress()) {
                    Navigator.this.m_navigator.invalidateNavigator(true);
                    Navigator.this.m_navigator.redraw();
                    Navigator.this.m_navigator.update();
                    Navigator.this.scheduleProgress();
                }
            }
        });
    }

    private ImageBuilder getModelBuilder() {
        return (ImageBuilder)this.getServiceLocator().getService(ViewModelBuilder.class.getName());
    }

    @Override
    public void operativeSetChange() {
        this.markDirty();
    }

    @Override
    public void synchronizationChange() {
        this.updateSynchbutton();
        this.updateSelectedRange();
    }

    private void updateSelectedRange() {
        IRange r = this.m_rangeController.getRange();
        this.update(r.getStartTimestamp(), r.getEndTimestamp(), false);
    }

    @Override
    public boolean isTypeChangeEnabled() {
        return this.m_typeChangedAllowed;
    }
}

