/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.flightrecorder.ui.components.range.ComponentControl;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class MoveForwardControl
extends ComponentControl {
    private final JComponentNavigator m_navigator;
    private final Image m_image;

    public MoveForwardControl(JComponentNavigator navigator) {
        super(Messages.NAVIGATOR_MOVE_FORWARD_TEXT);
        this.setToolTip(Messages.NAVIGATOR_MOVE_FORWARD_TEXT);
        this.m_image = CorePlugin.getDefault().getImage("forward_nav.gif");
        this.m_navigator = navigator;
    }

    public boolean isEnabled() {
        return this.m_navigator.getViewportMin() > this.m_navigator.getWorldMin();
    }

    public Point getPreferredPosition(Rectangle clientArea) {
        return new Point(clientArea.x + clientArea.width - IMAGE_PAD - this.m_image.getBounds().width, clientArea.y + clientArea.height - this.m_image.getBounds().height - IMAGE_PAD);
    }

    public void execute() {
        double viewPortMin = this.m_navigator.getViewportMin();
        double viewPortMax = this.m_navigator.getViewportMax();
        double width = viewPortMax - viewPortMin;
        double newMin = Math.min(viewPortMax + width, this.m_navigator.getWorldMax());
        this.m_navigator.setViewport(newMin, newMin + width);
    }

    public Image getImage() {
        return this.m_image;
    }
}

