/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.flightrecorder.ui.components.range.ComponentControl;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class MoveBackwardControl
extends ComponentControl {
    private final JComponentNavigator m_navigator;
    private final Image m_image;

    public MoveBackwardControl(JComponentNavigator navigator) {
        super(Messages.NAVIGATOR_MOVE_BACKWARD_TEXT);
        this.setToolTip(Messages.NAVIGATOR_MOVE_BACKWARD_TEXT);
        this.m_image = CorePlugin.getDefault().getImage("backward_nav.gif");
        this.m_navigator = navigator;
    }

    public boolean isEnabled() {
        return this.m_navigator.getViewportMin() > this.m_navigator.getWorldMin();
    }

    public void execute() {
        double viewPortMin = this.m_navigator.getViewportMin();
        double viewPortMax = this.m_navigator.getViewportMax();
        double width = viewPortMax - viewPortMin;
        double newMin = Math.max(viewPortMax - width, this.m_navigator.getWorldMin());
        this.m_navigator.setViewport(newMin, newMin + width);
    }

    public Image getImage() {
        return this.m_image;
    }

    public Point getPreferredPosition(Rectangle clientArea) {
        return new Point(clientArea.x + IMAGE_PAD, clientArea.y + clientArea.height - this.m_image.getBounds().height - IMAGE_PAD);
    }
}

