/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.FLRDataSeries;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.chart.ChartViewer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import se.hirt.greychart.AbstractAxis;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.DataSeriesProvider;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultXYLineRenderer;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.NanoTimestampFormatter;
import se.hirt.greychart.impl.NanosXAxis;
import se.hirt.greychart.impl.TimestampedDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageBuilder
extends ViewModelBuilder<BufferedImage> {
    private volatile Point m_size = new Point(1, 1);
    private volatile DefaultXYGreyChart m_chart = ChartViewer.create((DataSeriesProvider)new TimestampedDataProvider());
    private final ComponentDescriptor m_descriptor;
    private long m_startRange;
    private long m_endRange;

    public ImageBuilder(IServiceLocator serviceLocator, ComponentDescriptor descriptor) {
        super(serviceLocator, descriptor);
        this.m_descriptor = descriptor;
    }

    @Override
    protected BufferedImage buildModel(IEventTypeView view, IProgressMonitor monitor) {
        BufferedImage result = new BufferedImage(this.m_size.x, this.m_size.y, 5);
        this.m_chart.render(result.createGraphics(), new Rectangle(0, 0, this.m_size.x, this.m_size.y));
        return result;
    }

    public void setSize(int width, int height) {
        this.m_size = new Point(Math.max(1, width), Math.max(1, height));
    }

    public void setRange(long startTimeStamp, long endTimeStamp) {
        this.m_startRange = startTimeStamp;
        this.m_endRange = endTimeStamp;
    }

    void fillProvider() {
        TimestampedDataProvider provider = this.getDataProvider();
        for (com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor descriptor : this.getChartDescriptor().getDataSeriesDescriptors()) {
            provider.addDataSeries((DataSeries)new FLRDataSeries(this.getServiceLocator(), descriptor, this.getView()));
        }
        provider.fireDataChangeEvent(DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED);
    }

    private ChartDescriptor getChartDescriptor() {
        return (ChartDescriptor)this.m_descriptor.getComponentSettings().getChildObject("chartDescriptor", ChartDescriptor.class);
    }

    private YAxisDescriptor getAxisDescriptor(YAxis y) {
        if (y.getPosition() == YAxis.Position.LEFT) {
            return this.getChartDescriptor().getLeftYAxis();
        }
        return this.getChartDescriptor().getRightYAxis();
    }

    private TimestampedDataProvider getDataProvider() {
        return (TimestampedDataProvider)this.m_chart.getDataProvider();
    }

    private DataSeriesDescriptor.RenderingMode styleToRenderingMode(Style style) {
        switch (style) {
            case DENSITY: {
                return DataSeriesDescriptor.RenderingMode.DENSITY;
            }
            case NORMAL: {
                return DataSeriesDescriptor.RenderingMode.SUBSAMPLING;
            }
            case AVERAGING: {
                return DataSeriesDescriptor.RenderingMode.AVERAGING;
            }
            case INTEGRATING: {
                return DataSeriesDescriptor.RenderingMode.INTEGRATING;
            }
            case DENSITY_INTEGRATING: {
                return DataSeriesDescriptor.RenderingMode.DENSITY_INTEGRATING;
            }
        }
        return DataSeriesDescriptor.RenderingMode.AVERAGING;
    }

    protected void updateChart() {
        if (this.m_chart.getOptimizingProvider() != null) {
            this.m_chart.getOptimizingProvider().abort();
        }
        DefaultXYGreyChart chart = ChartViewer.create((DataSeriesProvider)new TimestampedDataProvider());
        TimestampedDataProvider provider = (TimestampedDataProvider)chart.getDataProvider();
        for (com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor descriptor : this.getChartDescriptor().getDataSeriesDescriptors()) {
            provider.addDataSeries((DataSeries)new FLRDataSeries(this.getServiceLocator(), descriptor, this.getView()));
        }
        provider.fireDataChangeEvent(DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED);
        NanosXAxis dax = (NanosXAxis)chart.getXAxis();
        dax.setRange((Number)this.m_startRange, (Number)this.m_endRange);
        TimestampedDataProvider timestampedDataProvider = (TimestampedDataProvider)chart.getDataProvider();
        AbstractAxis x = (AbstractAxis)chart.getXAxis();
        ((DefaultXYLineRenderer)chart.getSeriesPlotRenderer()).setExtrapolateMissingData(this.getChartDescriptor().getXAxis().getExtrapolateMissingData());
        x.setTitle("");
        x.setVisible(this.getChartDescriptor().getXAxis().getVisible());
        YAxis[] yaxis = chart.getYAxis();
        YAxis leftYAxis = null;
        YAxis rightYAxis = null;
        YAxis[] yAxisArray = yaxis;
        int n = yaxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            YAxisDescriptor axisDescriptor = this.getAxisDescriptor(y);
            y.setTitle(axisDescriptor.getTitle());
            y.setVisible(axisDescriptor.getVisible());
            ((DefaultYAxis)y).setAutoPadding(axisDescriptor.getAutoPad() ? 0.1 : 0.0);
            if (y.getPosition() == YAxis.Position.LEFT) {
                leftYAxis = y;
            } else if (y.getPosition() == YAxis.Position.RIGHT) {
                rightYAxis = y;
            }
            ++n2;
        }
        NanoTimestampFormatter ntf = new NanoTimestampFormatter();
        ntf.setTimeDateSeapator("\n");
        x.setFormatter((TickFormatter)ntf);
        List leftDescriptors = this.getChartDescriptor().getLeftYAxis().getDataSeries();
        List rightDescriptors = this.getChartDescriptor().getRightYAxis().getDataSeries();
        int index = 0;
        int leftCount = leftDescriptors.size();
        DataSeries[] dataSeriesArray = timestampedDataProvider.getDataSeries();
        int n3 = dataSeriesArray.length;
        int n4 = 0;
        while (n4 < n3) {
            DefaultYAxis currentYAxis;
            com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor dsd;
            DataSeries ds = dataSeriesArray[n4];
            if (index < leftCount) {
                dsd = (com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor)leftDescriptors.get(index);
                currentYAxis = (DefaultYAxis)leftYAxis;
            } else {
                dsd = (com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor)rightDescriptors.get(index - leftCount);
                currentYAxis = (DefaultYAxis)rightYAxis;
            }
            DefaultDataSeriesDescriptor greyDescriptor = new DefaultDataSeriesDescriptor();
            greyDescriptor.setTopColor(dsd.getFilled() ? dsd.getTopColor().getAWTColor() : null);
            greyDescriptor.setBottomColor(dsd.getFilled() ? dsd.getBottomColor().getAWTColor() : null);
            greyDescriptor.setLineColor(dsd.getLineColor().getAWTColor());
            greyDescriptor.setName(dsd.getName());
            greyDescriptor.setDescription(dsd.getDescription());
            greyDescriptor.setMode(this.styleToRenderingMode(dsd.getStyle()));
            greyDescriptor.setStacking(dsd.getStack());
            greyDescriptor.setDrawLine(dsd.getDrawLine());
            greyDescriptor.setYAxis(currentYAxis);
            chart.setDescriptor(ds, (DataSeriesDescriptor)greyDescriptor);
            ++index;
            ++n4;
        }
        chart.setXAxis(chart.getXAxis());
        this.m_chart = chart;
    }
}

