/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

public class CoordinateSystem {
    private double m_minWorld;
    private double m_maxWorld;
    private int m_maxDevice;
    private int m_minDevice;
    private final double[] m_world;
    private final double[] m_normalized;
    final int[] m_device;

    public CoordinateSystem(double minWorld, double maxWorld, int minDevice, int maxDevice, double[] normalizedCoordinates) {
        this.m_minWorld = minWorld;
        this.m_maxWorld = maxWorld;
        this.m_minDevice = minDevice;
        this.m_maxDevice = maxDevice;
        this.m_normalized = normalizedCoordinates;
        this.m_world = new double[normalizedCoordinates.length];
        this.m_device = new int[normalizedCoordinates.length];
        this.updateWorld();
        this.updateDevice();
    }

    public double getWorld(int index) {
        return this.m_world[index];
    }

    public double getNormalized(int index) {
        return this.m_normalized[index];
    }

    public int getCount() {
        return this.m_normalized.length;
    }

    public int getDevice(int index) {
        return this.m_device[index];
    }

    public int getDeviceSpan() {
        return this.m_maxDevice - this.m_minDevice;
    }

    public double getWorldSpan() {
        return this.m_maxWorld - this.m_minWorld;
    }

    public void setWorld(int index, double value) {
        this.m_world[index] = value;
        this.updateNormalized(index, value);
        this.updateDevice(index);
    }

    private void updateNormalized(int index, double value) {
        double delta = this.m_maxWorld - this.m_minWorld;
        this.m_normalized[index] = delta == 0.0 ? 0.0 : (this.m_world[index] - this.m_minWorld) / delta;
    }

    private void updateNormalized(int index, int value) {
        int delta = this.m_maxDevice - this.m_minDevice;
        this.m_normalized[index] = delta == 0 ? 0.0 : (double)(this.m_device[index] - this.m_minDevice) / (double)delta;
    }

    public void setDevice(int index, int value) {
        this.m_device[index] = value;
        this.updateNormalized(index, value);
        this.updateWorld(index);
    }

    public int getMinDevice() {
        return this.m_minDevice;
    }

    public int getMaxDevice() {
        return this.m_maxDevice;
    }

    public void setWorldRange(double min, double max) {
        this.m_minWorld = min;
        this.m_maxWorld = max;
        int n = 0;
        while (n < this.getCount()) {
            this.setWorld(n, this.m_world[n]);
            ++n;
        }
    }

    public void setDeviceRange(int min, int max) {
        this.m_minDevice = min;
        this.m_maxDevice = max;
        this.updateDevice();
    }

    private void updateWorld(int index) {
        this.m_world[index] = this.m_minWorld + this.getNormalized(index) * (this.m_maxWorld - this.m_minWorld);
    }

    private void updateWorld() {
        int n = 0;
        while (n < this.getCount()) {
            this.m_world[n] = this.m_minWorld + this.getNormalized(n) * (this.m_maxWorld - this.m_minWorld);
            ++n;
        }
    }

    private void updateDevice() {
        int n = 0;
        while (n < this.getCount()) {
            this.updateDevice(n);
            ++n;
        }
    }

    private void updateDevice(int index) {
        this.m_device[index] = (int)((double)this.m_minDevice + this.getNormalized(index) * (double)(this.m_maxDevice - this.m_minDevice) + 0.5);
    }

    public double getWorldMin() {
        return this.m_minWorld;
    }

    public double getWorldMax() {
        return this.m_maxWorld;
    }
}

