/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.properties;

import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.StringField;
import com.jrockit.mc.core.ui.fields.AbstractFieldTreeContentProvider;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.properties.ArrayValue;
import com.jrockit.mc.flightrecorder.ui.components.properties.EventRetrieverField;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.Map;

final class EventTypeTableContentProvider
extends AbstractFieldTreeContentProvider {
    private static final int DEFAULT_WIDTH = 100;
    private static int FIELD_COUNT = 0;
    public static final Field FIELD_NAME = new StringField(FIELD_COUNT++);
    public static final Field FIELD_RETRIEVER = new EventRetrieverField(FIELD_COUNT++);
    public static final Field FIELD_DESCRIPTION = new StringField(FIELD_COUNT++);
    public static final Field FIELD_IDENTIFIER = new StringField(FIELD_COUNT++);
    public static final Field FIELD_CONTENT_TYPE = new StringField(FIELD_COUNT++);
    public static final Field FIELD_RELATIONAL_KEY = new StringField(FIELD_COUNT++);
    private IEvent m_event;

    static {
        EventTypeTableContentProvider.FIELD_NAME.IDENTIFIER = "1";
        FIELD_NAME.setName(Messages.EVENT_PROPERTIES_COLUMN_NAME_TEXT);
        FIELD_NAME.setWidthWeight(1);
        FIELD_NAME.setMinWidth(100);
        EventTypeTableContentProvider.FIELD_RETRIEVER.IDENTIFIER = "2";
        FIELD_RETRIEVER.setName(Messages.EVENT_PROPERTIES_COLUMN_VALUE_TEXT);
        FIELD_RETRIEVER.setWidthWeight(3);
        FIELD_RETRIEVER.setMinWidth(100);
        EventTypeTableContentProvider.FIELD_DESCRIPTION.IDENTIFIER = "3";
        FIELD_DESCRIPTION.setName(Messages.EVENT_PROPERTIES_COLUMN_DESCRIPTION_TEXT);
        FIELD_DESCRIPTION.setWidthWeight(2);
        FIELD_DESCRIPTION.setMinWidth(100);
        EventTypeTableContentProvider.FIELD_IDENTIFIER.IDENTIFIER = "4";
        FIELD_IDENTIFIER.setName(Messages.EVETNT_PROPERTIES_COLUMN_IDENTIFIER_TEXT);
        FIELD_IDENTIFIER.setWidthWeight(2);
        FIELD_IDENTIFIER.setMinWidth(100);
        FIELD_IDENTIFIER.setVisible(false);
        EventTypeTableContentProvider.FIELD_CONTENT_TYPE.IDENTIFIER = "5";
        FIELD_CONTENT_TYPE.setName(Messages.EVENT_PROPERTIES_COLUMN_CONTENT_TYPE_TEXT);
        FIELD_CONTENT_TYPE.setWidthWeight(1);
        FIELD_CONTENT_TYPE.setMinWidth(100);
        FIELD_CONTENT_TYPE.setVisible(false);
        EventTypeTableContentProvider.FIELD_RELATIONAL_KEY.IDENTIFIER = "6";
        FIELD_RELATIONAL_KEY.setName(Messages.EVENT_PROPERTIES_COLUMN_RELATIONAL_KEY_TEXT);
        FIELD_RELATIONAL_KEY.setWidthWeight(1);
        FIELD_RELATIONAL_KEY.setMinWidth(100);
        FIELD_RELATIONAL_KEY.setVisible(false);
    }

    EventTypeTableContentProvider() {
    }

    public Object[] getColumnObject(Object element) {
        Object[] result = new Object[FIELD_COUNT];
        result[EventTypeTableContentProvider.FIELD_RETRIEVER.INDEX] = element;
        if (element instanceof IRetriever) {
            IRetriever descriptor = (IRetriever)element;
            result[EventTypeTableContentProvider.FIELD_NAME.INDEX] = descriptor.getName();
            result[EventTypeTableContentProvider.FIELD_DESCRIPTION.INDEX] = descriptor.getName();
            result[EventTypeTableContentProvider.FIELD_CONTENT_TYPE.INDEX] = descriptor.getContentTypeString();
            result[EventTypeTableContentProvider.FIELD_IDENTIFIER.INDEX] = descriptor.getAttributeIdentifier();
            result[EventTypeTableContentProvider.FIELD_RELATIONAL_KEY.INDEX] = descriptor.getRelationalKey();
            return result;
        }
        if (element instanceof ArrayValue[]) {
            result[EventTypeTableContentProvider.FIELD_NAME.INDEX] = "Array";
            return result;
        }
        if (element instanceof ArrayValue) {
            result[EventTypeTableContentProvider.FIELD_NAME.INDEX] = "[" + ((ArrayValue)element).getIndex() + "]";
            return result;
        }
        result[EventTypeTableContentProvider.FIELD_NAME.INDEX] = "";
        return result;
    }

    public Object[] getRowElements(Object element) {
        return this.getRowChildren(element);
    }

    protected Object[] getRowChildren(Object element) {
        if (element instanceof IEvent) {
            this.m_event = (IEvent)element;
            ArrayList<IRetriever> retriveser = new ArrayList<IRetriever>();
            Map map = ((IEvent)element).getEventType().getRetrivers();
            for (IRetriever r : map.values()) {
                if (!r.isVisible() || r.isSynthetic() || this.isStackTrace(r) || this.isThread(r)) continue;
                retriveser.add(r);
            }
            IRetriever threadRetriever = (IRetriever)map.get("thread");
            if (threadRetriever != null) {
                retriveser.add(threadRetriever);
            }
            return retriveser.toArray();
        }
        if (element instanceof IRetriever && this.m_event != null) {
            Object traceCandidate;
            IRetriever r = (IRetriever)element;
            Object threadCandidate = r.getValue(this.m_event);
            if (threadCandidate instanceof IMCThread && this.isThread(r) && (traceCandidate = this.m_event.getValue("stacktrace")) instanceof IMCStackTrace) {
                return ((IMCStackTrace)traceCandidate).getFrames().toArray();
            }
            return ArrayValue.createValue(((IRetriever)element).getValue(this.m_event));
        }
        if (element instanceof ArrayValue) {
            return ArrayValue.createValue(((ArrayValue)element).getValue());
        }
        return ArrayValue.createValue(element);
    }

    private boolean isThread(IRetriever r) {
        return "thread".equals(r.getAttributeIdentifier());
    }

    private boolean isStackTrace(IRetriever r) {
        return "stacktrace".equals(r.getAttributeIdentifier());
    }

    protected boolean hasRowChildren(Object element) {
        return this.getRowChildren(element).length > 0;
    }
}

