/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.properties;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.fields.ContentTypeField;
import com.jrockit.mc.flightrecorder.ui.components.properties.ArrayValue;

public final class EventRetrieverField
extends Field {
    private Object m_input;

    public EventRetrieverField(int id) {
        super(id);
    }

    public void setInput(Object input) {
        this.m_input = input;
    }

    public String formatObject(Object object) {
        if (this.m_input instanceof IEvent && object instanceof IRetriever) {
            IRetriever retriever = (IRetriever)object;
            IEvent event = (IEvent)this.m_input;
            Object value = retriever.getValue(event);
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                return "[" + array.length + "]";
            }
            return ContentTypeField.formatObject(retriever.getValue(event), retriever.getContentTypeString());
        }
        if (object instanceof IMCFrame) {
            IMCFrame f = (IMCFrame)object;
            String text = "";
            IMCMethod m = f.getMethod();
            if (m != null) {
                text = String.valueOf(text) + f.getMethod().getHumanReadable(false, false, true, false, true, false);
            }
            if (f.getFrameLineNumber() != null && f.getFrameLineNumber() > 0) {
                text = String.valueOf(text) + " line: " + f.getFrameLineNumber();
            }
            return text;
        }
        if (object instanceof ArrayValue) {
            ArrayValue av = (ArrayValue)object;
            Object o = av.getValue();
            if (o instanceof Object[]) {
                Object[] array = (Object[])o;
                return "[" + array.length + "]";
            }
            return ContentTypeField.formatObject(av.getValue(), null);
        }
        if (object instanceof ArrayValue[]) {
            return "[]";
        }
        return EventRetrieverField.defaultFormat((Object)object);
    }

    public void dispose() {
        this.m_input = null;
    }
}

