/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.properties;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.ui.fields.CommonLabelProvider;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class EventPropertiesImageProvider
extends LabelProvider {
    private final CommonLabelProvider m_commonLabelProvider = new CommonLabelProvider();
    private Object m_input;

    public Image getImage(Object element) {
        if (element instanceof IMCFrame) {
            return CorePlugin.getDefault().getImage("stckframe_obj.gif");
        }
        if (element instanceof IRetriever && this.m_input instanceof IEvent) {
            IRetriever retriever = (IRetriever)element;
            Object value = ((IRetriever)element).getValue((IEvent)this.m_input);
            Image image = this.m_commonLabelProvider.getImage(value);
            if (image != null) {
                return image;
            }
            if (UnitLookup.THREAD.getIdentifier().equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("thread_obj.gif");
            }
            if (UnitLookup.TIMESPAN.getIdentifier().equals(retriever.getContentTypeString())) {
                return FlightRecorderUI.getDefault().getImage("time-span-16.png");
            }
            if (UnitLookup.TIMESTAMP.getIdentifier().equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("clock16.gif");
            }
            if (UnitLookup.MEMORY.getIdentifier().equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("data.gif");
            }
            if ("stacktrace".equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("stckframe_obj.gif");
            }
            if ("http://www.oracle.com/fmw/ECID".equals(retriever.getRelationalKey())) {
                return FlightRecorderUI.getDefault().getImage("ecid.png");
            }
            if (UnitLookup.ADDRESS.getIdentifier().equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("adress.gif");
            }
            if (UnitLookup.PACKAGE.getIdentifier().equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("package_obj.gif");
            }
            if (UnitLookup.CLASS.getIdentifier().equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("class_obj.gif");
            }
            if (UnitLookup.METHOD.equals(retriever.getContentTypeString())) {
                return CorePlugin.getDefault().getImage("methdef_obj.gif");
            }
        }
        return CorePlugin.getDefault().getImage("property_obj.gif");
    }

    public void setInput(Object object) {
        this.m_input = object;
    }
}

