/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.model;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.FieldFactory;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.common.Toolkit;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingAttribute;

public final class MatchingValue {
    private final MatchingAttribute m_attribute;
    private final String m_objectName;
    private final String m_name;
    private final Object m_matchObject;

    MatchingValue(MatchingAttribute attribute, IRetriever retriever, Object matchObject) {
        this.m_name = retriever.getName();
        this.m_attribute = attribute;
        this.m_matchObject = matchObject;
        this.m_objectName = this.createObjectName(retriever, matchObject);
    }

    private String createObjectName(IRetriever retriever, Object matchObject) {
        Field field = FieldFactory.createFromDisplayUnitWithIndexIdentifier((UnitDescriptor)Toolkit.createUnit(retriever), (String)retriever.getAttributeIdentifier(), (int)0);
        String matchString = field.formatObject(matchObject);
        return matchString.length() < 40 ? matchString : String.valueOf(matchString.substring(0, 38)) + "...";
    }

    public String getIdentifier() {
        return this.getAttribute().getIdentifier();
    }

    public MatchingAttribute getAttribute() {
        return this.m_attribute;
    }

    public Object getMatchObject() {
        return this.m_matchObject;
    }

    public String getObjectName() {
        return this.m_objectName;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + this.m_matchObject;
    }
}

