/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.model;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingAttribute;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroup;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroupType;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingValue;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.Toolkit;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchingGroupCollection
implements Iterable<MatchingGroup> {
    private final TreeMap<MatchingGroupType, MatchingGroup> m_groups = new TreeMap();

    public MatchingGroupCollection(Iterable<IEvent> iterable) {
        this.initialize(iterable);
    }

    private void initialize(Iterable<IEvent> iterable) {
        if (iterable != null) {
            int visibleCount = Toolkit.getVisibleCount();
            int count = 0;
            for (IEvent e : iterable) {
                if (count == visibleCount) {
                    return;
                }
                this.addMetadataForEvent(e);
                ++count;
            }
        }
    }

    private void addMetadataForEvent(IEvent event) {
        for (Map.Entry entry : event.getEventType().getRetrivers().entrySet()) {
            IRetriever ret = (IRetriever)entry.getValue();
            MatchingGroup group = this.getMatchingGroup(ret);
            MatchingAttribute ma = group.getMatchingAttribute((String)entry.getKey());
            ma.addMatchingValue(new MatchingValue(ma, ret, ret.getValue(event)));
        }
    }

    public MatchingGroup getMatchingGroup(IRetriever retriever) {
        if (retriever.isRelational()) {
            return this.getGroup(MatchingGroupType.RELATIONAL);
        }
        if (!retriever.isSynthetic()) {
            return this.getGroup(MatchingGroupType.ATTRIBUTES);
        }
        return this.getGroup(MatchingGroupType.SYNTHETIC);
    }

    public MatchingGroup getGroup(MatchingGroupType type) {
        MatchingGroup group = this.m_groups.get((Object)type);
        if (group == null) {
            group = new MatchingGroup(type);
            this.m_groups.put(type, group);
        }
        return group;
    }

    @Override
    public Iterator<MatchingGroup> iterator() {
        return this.m_groups.values().iterator();
    }
}

