/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.model;

import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingAttribute;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroupType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchingGroup
implements Iterable<MatchingAttribute> {
    private final Map<String, MatchingAttribute> m_matchingAtributes = new HashMap<String, MatchingAttribute>();
    private final MatchingGroupType m_groupType;

    MatchingGroup(MatchingGroupType groupType) {
        this.m_groupType = groupType;
    }

    public boolean hasAttributes() {
        return this.m_matchingAtributes.size() > 0;
    }

    public String toString() {
        String s = "";
        for (MatchingAttribute matchingAttribute : this.getAttributes()) {
            s = String.valueOf(s) + matchingAttribute.getIdentifier() + " ";
        }
        return s;
    }

    public MatchingGroupType getType() {
        return this.m_groupType;
    }

    @Override
    public Iterator<MatchingAttribute> iterator() {
        return this.getAttributes().iterator();
    }

    MatchingAttribute getMatchingAttribute(String key) {
        MatchingAttribute matchingAttribute = this.m_matchingAtributes.get(key);
        if (matchingAttribute == null) {
            matchingAttribute = new MatchingAttribute(key);
            this.m_matchingAtributes.put(key, matchingAttribute);
        }
        return matchingAttribute;
    }

    private List<MatchingAttribute> getAttributes() {
        ArrayList<MatchingAttribute> attributeList = new ArrayList<MatchingAttribute>();
        attributeList.addAll(this.m_matchingAtributes.values());
        Collections.sort(attributeList, new Comparator<MatchingAttribute>(){

            @Override
            public int compare(MatchingAttribute a, MatchingAttribute b) {
                return a.getTitle().compareTo(b.getTitle());
            }
        });
        return attributeList;
    }
}

