/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.model;

import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchingAttribute
implements Iterable<MatchingValue> {
    private final List<MatchingValue> m_matchingValues = new ArrayList<MatchingValue>();
    private final String m_identifier;

    MatchingAttribute(String identifier) {
        this.m_identifier = identifier;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public void addMatchingValue(MatchingValue matchingValue) {
        this.m_matchingValues.add(matchingValue);
    }

    public int getValueCount() {
        return this.m_matchingValues.size();
    }

    public String getTitle() {
        String title = "";
        Iterator<String> it = this.createUniqueNameSet().iterator();
        while (it.hasNext()) {
            title = String.valueOf(title) + it.next();
            if (!it.hasNext()) continue;
            title = String.valueOf(title) + " / ";
        }
        return title;
    }

    private Set<String> createUniqueNameSet() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (MatchingValue v : this.m_matchingValues) {
            names.add(v.getName());
        }
        return names;
    }

    @Override
    public Iterator<MatchingValue> iterator() {
        return this.m_matchingValues.iterator();
    }

    public String toString() {
        return this.m_identifier;
    }
}

