/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.menus;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.handlers.MCContextMenuManager;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.AddAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.ClearAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.RemoveAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.SetAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.ValueMenu;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingAttribute;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroup;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroupCollection;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroupType;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.Toolkit;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public class OperativeSetMenu
extends MCContextMenuManager {
    public OperativeSetMenu(final IServiceLocator serviceLocator) {
        super(Messages.OPERATIVE_SET_MENU_TEXT, "operative.set");
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OperativeSetMenu.this.addEventActions(serviceLocator);
                OperativeSetMenu.this.add((IContributionItem)new Separator());
                OperativeSetMenu.this.addAttributesActions(serviceLocator);
            }
        });
    }

    private void addAttributesActions(IServiceLocator serviceLocator) {
        MatchingGroupCollection mgc = new MatchingGroupCollection(Toolkit.getSelection(serviceLocator));
        for (MatchingGroup group : mgc) {
            if (group.getType() != MatchingGroupType.RELATIONAL) continue;
            for (MatchingAttribute ma : group) {
                this.add((IContributionItem)new ValueMenu(serviceLocator, ma, String.valueOf(Messages.OPERATIVE_SET_ADD_MATCHING_TEXT) + ma.getTitle()));
            }
        }
    }

    private void addEventActions(IServiceLocator serviceLocator) {
        this.add((IAction)new AddAction(serviceLocator));
        this.add((IAction)new RemoveAction(serviceLocator));
        this.add((IAction)new SetAction(serviceLocator));
        this.add((IAction)new ClearAction(serviceLocator));
    }
}

