/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.menus;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.handlers.MCContextMenuManager;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.ValueMenu;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingAttribute;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroup;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroupCollection;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingGroupType;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;

final class AttributesMenu
extends MCContextMenuManager {
    public AttributesMenu(IServiceLocator serviceLocator, MatchingGroupCollection groupCollection) {
        super(Messages.OPERATIVE_SET_ATTRIBUTES_MENU_ADD_MATCHING_TEXT);
        this.addStandard(serviceLocator, groupCollection);
        this.addSynthetic(serviceLocator, groupCollection);
    }

    private void addSynthetic(IServiceLocator serviceLocator, MatchingGroupCollection groupCollection) {
        MatchingGroup synthetic = groupCollection.getGroup(MatchingGroupType.SYNTHETIC);
        if (synthetic.hasAttributes()) {
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new SyntheticMenu(serviceLocator, synthetic));
        }
    }

    private void addStandard(IServiceLocator serviceLocator, MatchingGroupCollection groupCollection) {
        for (MatchingAttribute ma : groupCollection.getGroup(MatchingGroupType.ATTRIBUTES)) {
            this.add((IContributionItem)new ValueMenu(serviceLocator, ma, ma.getTitle()));
        }
    }

    public static class SyntheticMenu
    extends MCContextMenuManager {
        public SyntheticMenu(IServiceLocator serviceLocator, MatchingGroup group) {
            super(Messages.OPERATIVE_SET_ATTRIBUTES_MENU_TEXT);
            for (MatchingAttribute ma : group) {
                this.add((IContributionItem)new ValueMenu(serviceLocator, ma, ma.getTitle()));
            }
        }
    }
}

