/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.actions;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.OperativeSetAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;

public final class SetAction
extends OperativeSetAction {
    public SetAction(IServiceLocator serviceLocator) {
        super(serviceLocator);
        this.setText(Messages.OPERATIVE_SET_SELECTION_ACTION_NAME_TEXT);
        this.setDescription(Messages.OPERATIVE_SET_SELECTION_ACTION_DESCRIPTION_TEXT);
    }

    public void process() {
        this.markCandidates();
        this.markOperativeSet();
    }

    private void markOperativeSet() {
        for (IEvent event : this.getAllEventsInRange()) {
            if (EventToolkit.isPartOfOperativeSetCandidate(event)) {
                EventToolkit.setPartOfOperativeSet(event, true);
                EventToolkit.setPartOfOperativeSetCandidate(event, false);
                continue;
            }
            EventToolkit.setPartOfOperativeSet(event, false);
        }
    }

    private void markCandidates() {
        for (IEvent event : this.getSelection()) {
            EventToolkit.setPartOfOperativeSetCandidate(event, true);
        }
    }
}

