/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.actions;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.OperativeSetAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.MatchingValue;

public final class AddMatchingValueAction
extends OperativeSetAction {
    private final MatchingValue m_matchingValue;

    public AddMatchingValueAction(IServiceLocator serviceLocator, MatchingValue mv, String title) {
        super(serviceLocator);
        this.setText(title);
        this.m_matchingValue = mv;
    }

    protected final void process() {
        this.addEvnetsWithMatchingValue(this.m_matchingValue, this.getRange());
    }

    private void addEvnetsWithMatchingValue(MatchingValue mv, IRange range) {
        String identifier = mv.getIdentifier();
        Object matchingObject = mv.getMatchObject();
        for (IEvent event : this.getAllEventsInRange()) {
            if (event.getStartTimestamp() <= range.getStartTimestamp() || event.getStartTimestamp() >= range.getEndTimestamp()) continue;
            this.matchForEvent(event.getEventType().getRetriever(identifier), matchingObject, event);
        }
    }

    private void matchForEvent(IRetriever r, Object matchingObject, IEvent event) {
        if (r != null) {
            if (matchingObject == null) {
                if (r.getValue(event) == null) {
                    EventToolkit.setPartOfOperativeSet(event, true);
                }
            } else if (matchingObject.equals(r.getValue(event))) {
                EventToolkit.setPartOfOperativeSet(event, true);
            }
        }
    }
}

