/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.inputs;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ColorInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.ExclusiveDetailInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IconInput;
import com.jrockit.mc.components.ui.settings.IntegerInput;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.components.ui.settings.StringInput;
import com.jrockit.mc.components.ui.settings.UnitInput;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetFilterDescription;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.EventTypeRepositoryInput;
import com.jrockit.mc.flightrecorder.ui.components.inputs.RepositoryCompatibleAttributeInput;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFactory {
    public static final String VISIBLE = "visible";
    public static final String EVENT_TYPES = "eventTypes";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String WEIGHT = "weight";
    public static final String MIN_WIDTH = "minimumWidth";
    public static final String ATTRIBUTE_IDENTIFIER = "attributeIdentifier";
    public static final String AGGREGATOR_IDENTIFIER = "aggregatorIdentifier";
    public static final String NAME = "name";
    public static final String UNIT = "unit";
    public static final String EMPHASIZED = "emphasized";
    public static final String COLOR = "color";
    public static final String FILTER_CONSTRAINED = "filterConstrained";
    public static final String ALLOW_OPERATIVE_SET = "allowOperativeSet";
    public static final String USE_FOR_FILTERING = "useForFiltering";
    public static final String SORTED = "sorted";
    public static final String NORMALIZE_DATA = "normalize";
    public static final String USE_BACKDROP = "showBackdrop";
    public static final String SORT_ASCENDING = "sortAscending";
    public static final String ONLY_OPERATIVE_SET = "operativeSet";
    public static final String CAPTION = "caption";
    public static final String ROLE = "role";
    public static final String ICON = "icon";

    public static IInput createColor() {
        return new ColorInput(COLOR, Messages.COMMON_INPUTS_COLOR_TEXT);
    }

    public static IInput createEventTypeInput(IServiceLocator serviceLocator) {
        return new EventTypeRepositoryInput(EVENT_TYPES, Messages.COMMON_INPUTS_EVENT_TYPE_REPOSITORY_TEXT, serviceLocator);
    }

    public static IInput createMainDescription(IServiceLocator serviceLocator) {
        return new LocalizedStringInput(DESCRIPTION, Messages.COMMON_INPUTS_DESCRIPTION_TEXT);
    }

    public static IInput createMainTitle(IServiceLocator serviceLocator) {
        return new LocalizedStringInput(TITLE, Messages.COMMON_INPUTS_TITLE_TEXT);
    }

    public static IInput createAttributeWithDynamicRepository(IServiceLocator locator, String repositoryLookupKey, boolean allowFullPath) {
        return new RepositoryCompatibleAttributeInput(ATTRIBUTE_IDENTIFIER, Messages.COMMON_INPUTS_EVENT_ATTRIBUTE_TEXT, locator, repositoryLookupKey, allowFullPath);
    }

    public static IInput createAttributeWithStaticRepository(IServiceLocator locator, EventTypeDescriptorRepository etr, boolean allowFullPath) {
        return new RepositoryCompatibleAttributeInput(ATTRIBUTE_IDENTIFIER, Messages.COMMON_INPUTS_EVENT_ATTRIBUTE_TEXT, locator, etr, allowFullPath);
    }

    public static IInput createUnit(boolean allowDerivative) {
        return new UnitInput(UNIT, allowDerivative);
    }

    public static IInput createAggregator(AggregatorDescriptor ... descriptors) {
        return InputFactory.createAggregator(Arrays.asList(descriptors));
    }

    public static IInput createAggregator() {
        return InputFactory.createAggregator(AggregatorFactory.getAggregators());
    }

    public static IInput createAggregator(List<AggregatorDescriptor> ads) {
        ComboInput ci = new ComboInput(AGGREGATOR_IDENTIFIER, Messages.COMMON_INPUTS_AGGREGATOR_TEXT);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (AggregatorDescriptor ad : ads) {
            map.put(ad.getIdentifier(), ad.getName());
        }
        ci.setItems(map);
        return ci;
    }

    public static IInput createInitiallySorted(List<? extends Object> detailList) {
        return new ExclusiveDetailInput(SORTED, Messages.COMMON_INPUTS_SORTED_TEXT, detailList);
    }

    public static IInput createPreferredSortOrder() {
        ComboInput ci = new ComboInput(SORT_ASCENDING, Messages.COMMON_INPUTS_SORT_ORDER_SELECTION_TEXT);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Boolean.TRUE.toString(), Messages.COMMON_INPUTS_SORT_ORDER_ASCENDING_TEXT);
        map.put(Boolean.FALSE.toString(), Messages.COMMON_INPUTS_SORT_ORDER_DESCENDING_TEXT);
        ci.setItems(map);
        return ci;
    }

    public static IInput createOperativeSet() {
        return new ComboInput(ONLY_OPERATIVE_SET, Messages.COMMON_INPUTS_ONLY_SHOW_OPERATIVE_SET_TEXT, OperativeSetFilterDescription.toMap());
    }

    public static IInput createNormalized() {
        return new BooleanInput(NORMALIZE_DATA, Messages.COMMON_INPUTS_NORMALIZED_TEXT);
    }

    public static IInput createBackdrop() {
        return new BooleanInput(USE_BACKDROP, Messages.COMMON_INPUTS_BACKDROP_TEXT);
    }

    public static IInput createFilter(List<? extends Object> detailList) {
        return new ExclusiveDetailInput(USE_FOR_FILTERING, Messages.COMMON_INPUTS_FILTERED_TEXT, detailList);
    }

    public static IInput createVisible() {
        return new BooleanInput(VISIBLE, Messages.COMMON_INPUTS_VISIBILE_TEXT);
    }

    public static IInput createDescription() {
        return new LocalizedStringInput(DESCRIPTION, "Description:");
    }

    public static StringInput createName() {
        return new LocalizedStringInput(NAME, Messages.COMMON_INPUTS_NAME_TEXT);
    }

    public static IInput createEmphasized() {
        return new BooleanInput(EMPHASIZED, Messages.COMMON_INPUTS_EMPHASIZED_TEXT);
    }

    public static IInput createColumnWeightFactor() {
        return new IntegerInput(WEIGHT, Messages.COMMON_INPUTS_COLUMN_WEIGHT_TEXT, Integer.valueOf(0), Integer.valueOf(1000));
    }

    public static IInput createMinimumWidth() {
        return new IntegerInput(MIN_WIDTH, Messages.COMMON_INPUTS_COLUMN_MINIMUM_WIDTH_TEXT, Integer.valueOf(1), Integer.valueOf(1000));
    }

    public static IInput createConstrainWithFilter() {
        return new BooleanInput(FILTER_CONSTRAINED, Messages.COMMON_INPUTS_ALLOW_USER_TO_CONSTRAIN_EVENT_TYPES_TEXT);
    }

    public static IInput createOperativeSetEnabled() {
        return new BooleanInput(ALLOW_OPERATIVE_SET, Messages.COMMON_INPUTS_ALLOW_USE_OF_OPERATIVE_SET_TEXT);
    }

    public static IInput createRole(Role ... supportedRoles) {
        if (supportedRoles.length == 0) {
            return InputFactory.createAllRolesInput();
        }
        return InputFactory.createSupportedRoles(supportedRoles);
    }

    private static IInput createSupportedRoles(Role ... roles) {
        HashMap<String, String> items = new HashMap<String, String>();
        Role[] roleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Role r = roleArray[n2];
            items.put(r.key, r.name);
            ++n2;
        }
        return new ComboInput(ROLE, Messages.COMMON_INPUTS_ROLE_SELECTION_TEXT, items);
    }

    private static IInput createAllRolesInput() {
        return new ComboInput(ROLE, Messages.COMMON_INPUTS_ROLE_SELECTION_TEXT, Role.toMap());
    }

    public static IInput createCaption() {
        return new BooleanInput(CAPTION, Messages.COMMON_INPUTS_CAPTION_TEXT);
    }

    public static IInput createDepth() {
        return new IntegerInput("treeExpansionLevel", Messages.TRACE_COMPONENT_EXPANDED_TREE_DEPTH, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
    }

    public static IInput createIcon() {
        IconInput i = new IconInput(ICON, "Icon:");
        i.setAllowClear(true);
        i.setSize(16);
        return i;
    }
}

