/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.inputs;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BrowseInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeWizard;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

final class EventTypeRepositoryInput
extends BrowseInput {
    public static final String KEY_EVENT_TYPE_IDENTIFIER = "eventType";
    private final IServiceLocator m_serviceLocator;

    public EventTypeRepositoryInput(String property, String name, IServiceLocator locator) {
        super(property, name);
        this.m_serviceLocator = locator;
    }

    protected boolean browse(Shell shell) {
        OnePageWizardDialog owd = new OnePageWizardDialog(shell, (IWizardPage)new EventTypeWizard(this.getEventDescriptorset(), this.m_serviceLocator));
        owd.setWidthConstaint(600, 600);
        owd.setHeightConstraint(400, 400);
        if (owd.open() == 0) {
            this.fireChange(IInput.STATUS_SETTING_CHANGE);
            return true;
        }
        return false;
    }

    private EventTypeDescriptorRepository getEventDescriptorset() {
        return (EventTypeDescriptorRepository)this.getSetting().getChildObject(this.getKey(), EventTypeDescriptorRepository.class);
    }

    protected String getTextualRepresentation() {
        String text = "";
        List<EventTypeDescriptor> list = this.getEventDescriptorset().getDescriptors();
        int n = 0;
        while (n < list.size()) {
            text = String.valueOf(text) + list.get(n).getName();
            if (n != list.size() - 1) {
                text = String.valueOf(text) + "; ";
            }
            ++n;
        }
        return text;
    }

    protected boolean hasValidData() {
        return !this.getEventDescriptorset().getDescriptors().isEmpty();
    }
}

