/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.RetrieverExtractor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InformationModelBuilder<T extends InformationDescriptor>
extends ViewModelBuilder<Map<String, Object>> {
    private final List<T> m_informationDescriptors;

    public InformationModelBuilder(IServiceLocator serviceLocator, List<T> descriptors, ComponentDescriptor cd) {
        super(serviceLocator, cd);
        this.m_informationDescriptors = descriptors;
    }

    @Override
    protected Map<String, Object> buildModel(IEventTypeView eventCloud, IProgressMonitor monitor) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int n = 0;
        while (n < this.m_informationDescriptors.size()) {
            if (!monitor.isCanceled()) {
                result.put(Integer.toString(n), this.calculateValue((InformationDescriptor)this.m_informationDescriptors.get(n), eventCloud));
            } else {
                result.put(Integer.toString(n), null);
            }
            ++n;
        }
        return result;
    }

    private Object calculateValue(T attributeDescriptor, IEventTypeView eventView) {
        String attributeIdentifier = ((InformationDescriptor)attributeDescriptor).getAttributeIdentifier();
        IAggregator aggregator = AggregatorFactory.createAggregator(((InformationDescriptor)attributeDescriptor).getAggregatorIdentifier());
        IEventType lastType = null;
        IRetriever lastRetriver = null;
        for (IEvent event : eventView) {
            if (event.getEventType() == lastType) {
                if (lastRetriver == null) continue;
                aggregator.add(lastRetriver.getValue(event));
                continue;
            }
            lastType = event.getEventType();
            RetrieverExtractor.lookupRetriever(event.getEventType(), attributeIdentifier);
            lastRetriver = (IRetriever)lastType.getRetrivers().get(attributeIdentifier);
            if (lastRetriver == null) continue;
            aggregator.add(lastRetriver.getValue(event));
        }
        if (((InformationDescriptor)attributeDescriptor).getUnit().getDerivative()) {
            return this.calculteDerivative(aggregator.getResult(), eventView.getRange());
        }
        return aggregator.getResult();
    }

    private Number calculteDerivative(Object value, IRange range) {
        if (value instanceof Number) {
            double numberValue = ((Number)value).doubleValue();
            double durationInSeconds = (double)range.getDuration() / 1.0E9;
            if (durationInSeconds > 0.0) {
                return new Double(numberValue / durationInSeconds);
            }
        }
        return null;
    }
}

