/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.common.Toolkit;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InformationMasterDetailFactory
implements IMasterDetailFactory {
    private final InformationDescriptorRepository m_informationDescriptorRepository;
    private final IServiceLocator m_serviceLocator;
    private List<IInput> m_detailsInputs = new ArrayList<IInput>();

    public InformationMasterDetailFactory(InformationDescriptorRepository idr, IServiceLocator serviceLocator) {
        this.m_informationDescriptorRepository = idr;
        this.m_serviceLocator = serviceLocator;
    }

    public List<IInput> createDetailInput() {
        return this.m_detailsInputs;
    }

    public void setDetailSInput(List<IInput> inputs) {
        this.m_detailsInputs = inputs;
    }

    public List createDetailList() {
        return this.m_informationDescriptorRepository.getInformationDescriptors();
    }

    public IInput createDetailBaseInput(Shell shell) {
        IInput eventTypeInput = InputFactory.createEventTypeInput(this.m_serviceLocator);
        eventTypeInput.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
                if (status == IInput.STATUS_SETTING_CHANGE) {
                    InformationMasterDetailFactory.this.m_informationDescriptorRepository.getInformationDescriptors().clear();
                }
            }
        });
        return eventTypeInput;
    }

    public List<IInput> createMainInputs() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(InputFactory.createRole(Role.INDEPENDENT, Role.SLAVE));
        return list;
    }

    public String createMasterTableTitle() {
        return Messages.ATTRIBUTE_SUMMARY_CONFIGURATION_MASTER_TABLE_TITLE;
    }

    public List<Object> createNew(Shell shell) {
        EventTypeDescriptorRepository eventTypes = this.getEventTypeDescriptorBase();
        if (eventTypes.getDescriptors().isEmpty()) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.ATTRIBUTE_SUMMARY_CONFIGURATION_MISSING_EVENT_TYPE_TEXT, (String)Messages.ATTRIBUTE_SUMMARY_CONFIGURATION_MUST_SELECT_AT_LEAST_ONE_EVENT_TEXT);
            return null;
        }
        BrowseForEventAttributeWizard bfew = new BrowseForEventAttributeWizard(this.m_serviceLocator, 2, false, this.m_informationDescriptorRepository.getEventTypeDescriptorBase());
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfew);
        dialog.setWidthConstaint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0) {
            ArrayList<Object> descs = new ArrayList<Object>();
            Object[] object = bfew.getSelection().toArray();
            if (object.length > 0) {
                int n = 0;
                while (n < object.length) {
                    descs.add(this.createDialDescriptor((IRetriever)object[n]));
                    ++n;
                }
            }
            return descs;
        }
        return null;
    }

    private InformationDescriptor createDialDescriptor(IRetriever retriever) {
        DialDescriptor informationDescriptor = new DialDescriptor();
        informationDescriptor.setName(retriever.getName());
        informationDescriptor.setDescription(retriever.getDescription());
        informationDescriptor.setAttributeIdentifier(retriever.getAttributeIdentifier());
        informationDescriptor.setUnit(Toolkit.createUnit(retriever));
        if (retriever.isTextual()) {
            informationDescriptor.setAggregatorIdentifier(AggregatorFactory.FIRST_VALUE.getIdentifier());
        }
        if ("metadata".equals(retriever.getContentTypeString())) {
            informationDescriptor.setAggregatorIdentifier(AggregatorFactory.FIRST_VALUE.getIdentifier());
        }
        return informationDescriptor;
    }

    private EventTypeDescriptorRepository getEventTypeDescriptorBase() {
        return this.m_informationDescriptorRepository.getEventTypeDescriptorBase();
    }

    public TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer viewer = new FieldTableViewer(table, this.createFields());
        viewer.setContentProvider((IContentProvider)new InformationContentProvider());
        return viewer;
    }

    private Field[] createFields() {
        return new Field[]{InformationContentProvider.FIELD_NAME, InformationContentProvider.FIELD_DESCRIPTION};
    }

    public List<IInput> createSpecific() {
        return null;
    }

    public String createSpecificTitle() {
        return null;
    }
}

