/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldRenderer;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.column.RetrieverExtractor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationComponent
extends AbstractUIComponent
implements INavigatorSelectionChangeListener,
IEventConsumer {
    private static final String INFORMATION_DESCRIPTOR_REPOSITORY = "informationDescriptorRepository";
    private FieldRenderer m_renderer;

    public boolean initialize(IServiceLocator serviceLocator) {
        boolean initOk = super.initialize(serviceLocator);
        InformationModelBuilder<InformationDescriptor> informationModelBuilder = new InformationModelBuilder<InformationDescriptor>(serviceLocator, this.getInformationDescriptors(), this.getComponentDescriptor());
        informationModelBuilder.setEventView(this.createView());
        informationModelBuilder.addObserver(new Observer(){

            public void update(Observable observable, Object arg) {
                if (InformationComponent.this.m_renderer != null) {
                    InformationComponent.this.sceduleFieldUpdate((Map)InformationComponent.this.getBuilder().getModel(), InformationComponent.this.getBuilder().getView().getRange());
                }
            }
        });
        serviceLocator.registerService(informationModelBuilder);
        return initOk;
    }

    public Control createPart(Composite parent) {
        this.m_renderer = new FieldRenderer(parent, this.getFormToolkit(), null, true);
        this.m_renderer.render(this.createFields());
        Composite client = this.m_renderer.getClient();
        client.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        return client;
    }

    @Override
    public void onChange(long startTime, long endTime) {
        if (this.getRepository().getRole() == Role.INDEPENDENT) {
            this.getBuilder().getView().setRange((IRange)new Range(startTime, endTime));
            this.markDirty();
        }
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.getBuilder().stop();
        return super.dispose(serviceLocator);
    }

    private List<InformationDescriptor> getInformationDescriptors() {
        return this.getRepository().getInformationDescriptors();
    }

    private Field[] createFields() {
        List<InformationDescriptor> informationDescriptors = this.getInformationDescriptors();
        int index = 0;
        Field[] fields = new Field[informationDescriptors.size()];
        for (InformationDescriptor infoDescriptor : informationDescriptors) {
            fields[index] = EventFieldToolkit.createField(infoDescriptor, infoDescriptor.getAttributeIdentifier(), index);
            ++index;
        }
        return fields;
    }

    private InformationDescriptorRepository getRepository() {
        return (InformationDescriptorRepository)this.getComponentSettings().getChildObject(INFORMATION_DESCRIPTOR_REPOSITORY, InformationDescriptorRepository.class);
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    @Override
    public void consumeEvents(Iterable<IEvent> events) {
        if (this.getRepository().getRole().equals((Object)Role.SLAVE)) {
            this.updateIterator(events);
        }
    }

    private void updateIterator(Iterable<IEvent> events) {
        Iterator<IEvent> eventIterator = events.iterator();
        List<InformationDescriptor> list = this.getRepository().getInformationDescriptors();
        Object[] result = new Object[list.size()];
        while (eventIterator.hasNext()) {
            IEvent event = eventIterator.next();
            IEventType type = event.getEventType();
            int index = 0;
            for (InformationDescriptor infoDescriptor : list) {
                IRetriever r = RetrieverExtractor.lookupRetriever(type, infoDescriptor.getAttributeIdentifier());
                if (r != null) {
                    result[index] = r.getValue(event);
                }
                ++index;
            }
        }
        this.m_renderer.updateFields(result, (Object)this.getFlightRecording());
    }

    protected InformationModelBuilder<DialDescriptor> getBuilder() {
        return (InformationModelBuilder)this.getServiceLocator().getService(InformationModelBuilder.class);
    }

    private void sceduleFieldUpdate(final Map<String, Object> result, final IRange range) {
        if (result != null) {
            DisplayToolkit.safeAsyncExec((Widget)this.m_renderer.getClient(), (Runnable)new Runnable(){

                public void run() {
                    InformationComponent.this.updateFields(result, range);
                }
            });
        }
    }

    public void refresh() {
        this.getBuilder().scheduleRebuild();
    }

    private void updateFields(Map<String, Object> result, IRange range) {
        List<InformationDescriptor> desc = this.getInformationDescriptors();
        Object[] values = result.values().toArray();
        Object[] data = new Object[values.length];
        int n = 0;
        while (n < desc.size()) {
            data[n] = values[n];
            ++n;
        }
        this.m_renderer.updateFields(data, (Object)this.getFlightRecording());
    }

    protected void initializeUI() {
        super.initializeUI();
        this.getBuilder().getView().setRange((IRange)new Range(this.getStartService().getStartTimeStamp(), this.getStartService().getEndTimeStamp()));
        this.getBuilder().setOperativeSetEnabled(false);
        EventTypeAcceptor eta = new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase());
        this.getBuilder().getView().setEventTypes(eta.getAcceptedSet());
    }

    private IEventTypeView createView() {
        if (this.getRepository().getRole() == Role.INDEPENDENT) {
            return this.getFlightRecording().createView();
        }
        return new SimpleView();
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }
}

