/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.MethodField;
import com.jrockit.mc.core.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldTreeViewer;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewerComponent;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.successors.IFrameConsumer;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TreeContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.OperativeSetMenu;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceTreeComponent
extends ColumnViewerComponent
implements ITypeVisibilityChange,
INavigatorSelectionChangeListener,
IEventConsumer {
    public static final String TREE_EXPANSION_LEVEL = "treeExpansionLevel";

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = this.getFormToolkit().createTree(parent, 268501762);
        FieldTreeViewer viewer = new FieldTreeViewer(tree, this.getFields());
        viewer.getTree().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new BoldFieldLabelProvider(this.getFields()));
        viewer.setInput((Object)this.getModelBuilder());
        this.hookModelView((ContentViewer)viewer, this.getModelBuilder());
        this.hookSelectionListener(viewer);
        return viewer;
    }

    protected void refreshViewer(ContentViewer viewer) {
        viewer.refresh();
        ((AbstractTreeViewer)viewer).expandToLevel(this.getExpansionLevel());
    }

    private int getExpansionLevel() {
        return (Integer)PersistenceToolkit.getSetting((Object)this.getRepository()).getChildObject(TREE_EXPANSION_LEVEL, Integer.class);
    }

    private void pushSelection(IStructuredSelection selection) {
        TraceModel model = (TraceModel)this.getModelBuilder().getModel();
        Iterable<IEvent> events = this.createIterable(selection, model);
        ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setRange(this.getModelBuilder().getView().getRange());
        ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setEventFactory(events);
        if (this.getRepository().getRole() == Role.MASTER) {
            ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
            for (FrameNode node : selection) {
                if (node.getFrame() == null) continue;
                frames.add(node.getFrame());
            }
            for (IFrameConsumer ec : this.getComponents().getComponentsInAncestorScopes(IFrameConsumer.class)) {
                ec.consumeFrame(frames, events);
            }
        }
    }

    private Iterable<IEvent> createIterable(IStructuredSelection selection, TraceModel model) {
        if (!selection.isEmpty()) {
            ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
            for (FrameNode node : selection) {
                frames.add(node.getFrame());
            }
            return model.createIterable(frames);
        }
        return new ArrayList<IEvent>();
    }

    private void hookSelectionListener(FieldTreeViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TraceTreeComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    @Override
    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            serviceLocator.registerService((Object)new FrameEqualityChecker());
            serviceLocator.registerService((Object)new OperativeSetService());
            this.hookModelBuilder();
            this.hookFrameEqualityChecker();
            return true;
        }
        return false;
    }

    @Override
    protected ViewModelBuilder createModelBuilder() {
        return new ViewModelBuilder<TraceModel>(this.getServiceLocator(), this.getComponentDescriptor()){

            @Override
            protected TraceModel buildModel(IEventTypeView eventCloud, IProgressMonitor monitor) {
                TraceModel m = new TraceModel(null, this.getServiceLocator(), TraceTreeComponent.this.getRepository(), eventCloud);
                m.rebuild();
                if (m.isMaxedOut()) {
                    this.setLastBuildMessage(Messages.TRACE_COMPONENT_TOO_MAY_TRACES_TO_SHOW_THEM_ALL_TEXT);
                }
                return m;
            }
        };
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.getModelBuilder().stop();
        return super.dispose(serviceLocator);
    }

    protected void hookModelBuilder() {
        this.getModelBuilder().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                DisplayToolkit.safeAsyncExec((Widget)TraceTreeComponent.this.getViewer().getControl(), (Runnable)new Runnable(){

                    public void run() {
                        TraceTreeComponent.this.getViewer().refresh();
                    }
                });
            }
        });
    }

    protected void hookFrameEqualityChecker() {
        this.getFrameEqualityChecker().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                TraceTreeComponent.this.getModelBuilder().scheduleRebuild();
            }
        });
    }

    @Override
    public HistogramColumnDescriptorRepository getRepository() {
        return (HistogramColumnDescriptorRepository)this.getComponentSettings().getChildObject("columnDescriptorRepository", HistogramColumnDescriptorRepository.class);
    }

    private FrameEqualityChecker getFrameEqualityChecker() {
        return (FrameEqualityChecker)this.getServiceLocator().getService(FrameEqualityChecker.class);
    }

    @Override
    public final Field[] createFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        fields.add(this.createMethodField(index));
        ++index;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            fields.add(EventFieldToolkit.createField(column, column.getAttributeIdentifier(), index));
            ++index;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private Field createMethodField(int index) {
        MethodField field = new MethodField(0);
        field.setName(Messages.TRACE_COMPONENT_TRACE_COLUMN_TEXT);
        field.setVisible(true);
        field.setMinWidth(300);
        field.setWidthWeight(300);
        field.setModifiable(false);
        field.setSortOrder(true);
        return field;
    }

    @Override
    protected Field findSortedField() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            assert (index < this.getFields().length);
            if (column.isInitialSortColumn()) {
                return this.getFields()[index + 1];
            }
            ++index;
        }
        return this.getFields()[0];
    }

    public void initalizeUI() {
        this.updateSorting();
        this.getMenuManager().add((IContributionItem)new OperativeSetMenu(this.getServiceLocator()));
    }
}

