/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNodeTreeBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceModel
extends HistogramModel {
    protected final FrameEqualityChecker m_frameEqualityChecker;
    private final FrameNode m_topNode;

    public TraceModel(IMCFrame frame, IServiceLocator serviceLocator, HistogramColumnDescriptorRepository cd, IEventTypeView eventCloud) {
        super(cd, serviceLocator, eventCloud);
        this.m_frameEqualityChecker = (FrameEqualityChecker)serviceLocator.getService(FrameEqualityChecker.class);
        this.m_topNode = new FrameNode(null, frame, this.getGathererFactory().createGather());
    }

    public FrameNode getRoot() {
        return this.m_topNode;
    }

    public FrameEqualityChecker getFrameEqualityChecker() {
        return this.m_frameEqualityChecker;
    }

    @Override
    public void rebuild() {
        this.buildTraceHistogram();
        this.buildNodes();
    }

    public void buildTraceHistogram() {
        GathererFactory factory = this.getGathererFactory();
        for (IEvent e : this.getEventView()) {
            Object v;
            RetriverHolder mapper = factory.getRetrivers(e.getEventType());
            if (mapper == null || mapper.getGroupBy() == null || !((v = mapper.getGroupBy().getValue(e)) instanceof IMCStackTrace)) continue;
            this.getHistogramItem(v).add(mapper, e);
        }
    }

    Iterable<IEvent> createIterable(List<IMCFrame> framesToCheck) {
        HashMap<IMCStackTrace, Boolean> lookup = new HashMap<IMCStackTrace, Boolean>();
        ArrayList<IEvent> naive = new ArrayList<IEvent>();
        GathererFactory factory = this.getGathererFactory();
        for (IEvent e : this.getEventView()) {
            Object v;
            RetriverHolder mapper = factory.getRetrivers(e.getEventType());
            if (mapper == null || mapper.getGroupBy() == null || !((v = mapper.getGroupBy().getValue(e)) instanceof IMCStackTrace) || !this.traceContainsFrames((IMCStackTrace)v, framesToCheck, lookup)) continue;
            naive.add(e);
        }
        return naive;
    }

    private boolean traceContainsFrames(IMCStackTrace trace, List<IMCFrame> framesToCheck, Map<IMCStackTrace, Boolean> quickLookup) {
        Boolean containsFrame = quickLookup.get(trace);
        if (containsFrame == null) {
            for (IMCFrame f : framesToCheck) {
                for (IMCFrame checkFrame : trace.getFrames()) {
                    if (!f.getMethod().equals(checkFrame.getMethod())) continue;
                    quickLookup.put(trace, Boolean.TRUE);
                    return true;
                }
            }
            quickLookup.put(trace, Boolean.FALSE);
            return false;
        }
        return containsFrame;
    }

    protected void buildNodes() {
        FrameNodeTreeBuilder builder = new FrameNodeTreeBuilder(this.getRoot(), this.m_frameEqualityChecker, this.getGathererFactory());
        for (HistogramItem ti : this.getHistogramItems()) {
            builder.addTrace(ti);
        }
    }
}

