/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;

public class FrameNodeTreeBuilder {
    private final FrameNode m_topNode;
    private final GathererFactory m_gathererFactory;
    private final FrameEqualityChecker m_frameEqualityChecker;

    public FrameNodeTreeBuilder(FrameNode topNode, FrameEqualityChecker frameEqualityChecker, GathererFactory gathererFactory) {
        this.m_gathererFactory = gathererFactory;
        this.m_frameEqualityChecker = frameEqualityChecker;
        this.m_topNode = topNode;
    }

    protected final FrameNode getTopNode() {
        return this.m_topNode;
    }

    protected void addTrace(HistogramItem traceInformation) {
        FrameNode frameNode = this.getTopNode();
        IAggregator[] aggregators = traceInformation.getAggregators();
        Object object = traceInformation.getKey();
        if (object instanceof IMCStackTrace) {
            IMCStackTrace s = (IMCStackTrace)object;
            for (IMCFrame frame : s.getFrames()) {
                frameNode = this.nextFrameNode(traceInformation, frameNode, frame);
                frameNode.addAggregators(aggregators);
            }
        }
    }

    protected final FrameNode nextFrameNode(HistogramItem item, FrameNode currentNode, IMCFrame addFrame) {
        for (FrameNode childNode : currentNode.getChildren()) {
            if (!this.m_frameEqualityChecker.isEqual(childNode.getFrame(), addFrame)) continue;
            return childNode;
        }
        FrameNode node = this.createFrameNode(item, addFrame);
        currentNode.addChild(node);
        return node;
    }

    private FrameNode createFrameNode(HistogramItem item, IMCFrame frame) {
        return new FrameNode(item, frame, this.m_gathererFactory.createGather());
    }
}

