/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.Gatherer;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FrameNode
implements IMCAggregatedFrame {
    private final List<FrameNode> m_children = new LinkedList<FrameNode>();
    private final IMCFrame m_frame;
    private final Gatherer m_gatherer;
    private final HistogramItem m_histogramItem;

    public FrameNode(HistogramItem item, IMCFrame frame, Gatherer gatherer) {
        this.m_frame = frame;
        this.m_gatherer = gatherer;
        this.m_histogramItem = item;
    }

    public HistogramItem getHistogram() {
        return this.m_histogramItem;
    }

    public void addChild(FrameNode node) {
        this.m_children.add(node);
    }

    public IMCFrame getFrame() {
        return this.m_frame;
    }

    public Object[] getResult() {
        return this.m_gatherer.getValues();
    }

    public List<FrameNode> getChildren() {
        return this.m_children;
    }

    public void addValues(Object[] values) {
        this.m_gatherer.add(values);
    }

    public void addAggregators(IAggregator[] gators1) {
        IAggregator[] gators2 = this.m_gatherer.getAggregators();
        int n = 0;
        while (n < gators2.length) {
            gators2[n].addFromAggregator(gators1[n]);
            ++n;
        }
    }

    public IMCAggregatedFrame.AggregationType getAggregationType() {
        return IMCAggregatedFrame.AggregationType.PREDECESSORS;
    }

    public IMCMethod getMethod() {
        return this.m_frame.getMethod();
    }

    public Integer getBCI() {
        return this.m_frame.getBCI();
    }

    public Integer getFrameLineNumber() {
        return this.m_frame.getFrameLineNumber();
    }

    public String getType() {
        return null;
    }
}

