/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.successors;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.histogram.successors.IFrameConsumer;
import com.jrockit.mc.flightrecorder.ui.components.histogram.successors.SuccessorTraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceTreeComponent;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuccessorComponent
extends TraceTreeComponent
implements IFrameConsumer {
    private volatile List<IMCFrame> m_frames = new ArrayList<IMCFrame>();

    @Override
    protected ViewModelBuilder createModelBuilder() {
        return new ViewModelBuilder<TraceModel>(this.getServiceLocator(), this.getComponentDescriptor()){

            @Override
            protected SuccessorTraceModel buildModel(IEventTypeView cloud, IProgressMonitor monitor) {
                IMCFrame r = SuccessorComponent.this.m_frames.isEmpty() ? null : (IMCFrame)SuccessorComponent.this.m_frames.iterator().next();
                SuccessorTraceModel m = new SuccessorTraceModel(r, this.getServiceLocator(), SuccessorComponent.this.getRepository(), cloud);
                m.rebuild();
                if (m.isMaxedOut()) {
                    this.setLastBuildMessage(Messages.TRACE_COMPONENT_TOO_MAY_TRACES_TO_SHOW_THEM_ALL_TEXT);
                }
                return m;
            }
        };
    }

    @Override
    public void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
    }

    @Override
    public void consumeEvents(Iterable<IEvent> events) {
        if (this.getRepository().getRole() == Role.SLAVE) {
            this.m_frames = this.createFrameList(events);
            IEventTypeView oldView = this.getModelBuilder().getView();
            IEventTypeView newView = this.getFlightRecording().createView();
            newView.setRange(oldView.getRange());
            newView.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()).getAcceptedSet());
            newView.setFilter(oldView.getFilter());
            this.getModelBuilder().setEventView(newView);
            this.markDirty();
        }
    }

    private List<IMCFrame> createFrameList(Iterable<IEvent> events) {
        IEvent e;
        IMCFrame frame;
        Iterator<IEvent> ite = events.iterator();
        ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
        if (ite.hasNext() && (frame = (IMCFrame)(e = ite.next()).getValue("(stacktrace.frame)")) != null) {
            frames.add(frame);
        }
        return frames;
    }

    @Override
    public void consumeFrame(List<IMCFrame> frames, Iterable<IEvent> possibleEvents) {
        if (this.getRepository().getRole() == Role.SLAVE) {
            IEventTypeView oldView = this.getModelBuilder().getView();
            SimpleView newView = new SimpleView(possibleEvents);
            newView.setRange(oldView.getRange());
            newView.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()).getAcceptedSet());
            newView.setFilter(oldView.getFilter());
            this.getModelBuilder().setEventView(newView);
            this.markDirty();
            this.m_frames = frames;
            this.markDirty();
        }
    }
}

