/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.event;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramModel;

public final class EventHistogramModel
extends HistogramModel {
    public EventHistogramModel(HistogramColumnDescriptorRepository repository, IServiceLocator locator, IEventTypeView cloud) {
        super(repository, locator, cloud);
    }

    protected void rebuild() {
        GathererFactory factory = this.getGathererFactory();
        for (IEvent event : this.getEventView()) {
            Object key;
            RetriverHolder mapper = factory.getRetrivers(event.getEventType());
            if (mapper == null || mapper.getGroupBy() == null || (key = mapper.getGroupBy().getValue(event)) == null) continue;
            this.getHistogramItem(key).add(mapper, event);
        }
        this.normalize();
    }

    private void normalize() {
        int index = 0;
        for (ColumnDescriptor cd : this.getRepository().getColumnDescriptors()) {
            if (cd.getNormalize()) {
                double total = this.calculateTotalForIndex(index);
                if (total > 0.0 && !Double.isNaN(total)) {
                    this.normalizeIndex(index, total);
                } else {
                    this.zeroOutIndex(index);
                }
            }
            ++index;
        }
    }

    private void zeroOutIndex(int index) {
        for (HistogramItem item : this.getHistogramItems()) {
            Object normalizationValue = item.getValue(index);
            if (!(normalizationValue instanceof Number)) continue;
            item.getValues()[index] = null;
        }
    }

    private void normalizeIndex(int index, double normalizationFactor) {
        for (HistogramItem item : this.getHistogramItems()) {
            Object normalizationValue = item.getValue(index);
            if (!(normalizationValue instanceof Number)) continue;
            item.setValues(index, new Double(((Number)normalizationValue).doubleValue() / normalizationFactor));
        }
    }

    private double calculateTotalForIndex(int index) {
        double total = 0.0;
        for (HistogramItem item : this.getHistogramItems()) {
            Object normalizationValue = item.getValue(index);
            if (!(normalizationValue instanceof Number)) continue;
            total += ((Number)normalizationValue).doubleValue();
        }
        return total;
    }
}

