/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.api.PathDescriptorRepository;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieverItem
implements Comparable<RetrieverItem> {
    private final IRetriever m_retriever;
    private final IEventType m_eventType;
    private final String m_humanReadableName;
    private final String m_eventFolderPath;
    private final String m_eventTypePath;

    RetrieverItem(IEventType type, IRetriever retriever) {
        this.m_eventType = type;
        this.m_retriever = retriever;
        this.m_humanReadableName = RetrieverItem.createHumanReadableName(type, retriever);
        this.m_eventFolderPath = this.createEventPath(type, -1);
        this.m_eventTypePath = this.createEventPath(type, 0);
    }

    private String createEventPath(IEventType type, int depthDelta) {
        PathDescriptorRepository rep = PathDescriptorRepository.getDefault();
        PathDescriptor[] pd = rep.createAllPathDescriptors(type.getPath());
        StringBuilder s = new StringBuilder();
        int n = 0;
        while (n < pd.length + depthDelta) {
            s.append(pd[n].getName());
            s.append(" / ");
            ++n;
        }
        return s.toString();
    }

    private static String createHumanReadableName(IEventType type, IRetriever retriever) {
        PathDescriptorRepository rep = PathDescriptorRepository.getDefault();
        PathDescriptor[] pd = rep.createAllPathDescriptors(type.getPath());
        StringBuilder s = new StringBuilder();
        int n = 0;
        while (n < pd.length) {
            s.append(pd[n].getName());
            s.append(n < pd.length - 1 ? " / " : " - ");
            ++n;
        }
        return s + retriever.getName();
    }

    @Override
    public int compareTo(RetrieverItem o) {
        String subB;
        String subA;
        int minumSize;
        if (!this.m_eventFolderPath.equals(o.m_eventFolderPath) && (minumSize = Math.min(this.m_eventFolderPath.length(), o.m_eventFolderPath.length())) > 0 && (subA = this.m_eventFolderPath.substring(0, minumSize)).compareTo(subB = o.m_eventFolderPath.substring(0, minumSize)) == 0) {
            return o.m_eventFolderPath.length() - this.m_eventFolderPath.length();
        }
        return this.m_eventTypePath.compareTo(o.m_eventTypePath);
    }

    public IEventType getEventType() {
        return this.m_eventType;
    }

    public IRetriever getRetriever() {
        return this.m_retriever;
    }

    public String toString() {
        return this.m_humanReadableName;
    }

    public boolean equals(Object o) {
        if (o instanceof RetrieverItem) {
            RetrieverItem r = (RetrieverItem)o;
            return this.hasSameEventType(r, this) && this.hasSameRetriever(r, this);
        }
        return false;
    }

    private boolean hasSameRetriever(RetrieverItem a, RetrieverItem b) {
        return a.getRetriever().getAttributeIdentifier().equals(b.getRetriever().getAttributeIdentifier());
    }

    private boolean hasSameEventType(RetrieverItem a, RetrieverItem b) {
        return a.getRetriever().getEventTypePath().equals(b.getRetriever().getEventTypePath());
    }
}

