/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HistogramSelectionIterator
implements Iterator<IEvent> {
    private final Iterator<HistogramItem> m_itemIterator;
    private final IEventTypeView m_eventCloud;
    private Iterator<IEvent> m_eventIterator;
    private IEvent m_event;
    private GathererFactory m_gatherFactory;

    HistogramSelectionIterator(IStructuredSelection selection, GathererFactory gf, IEventTypeView cloud) {
        this.m_itemIterator = selection.iterator();
        this.m_gatherFactory = gf;
        this.m_eventCloud = cloud;
        this.skipForwardItem();
    }

    private void skipForwardEvent() {
        if (this.m_eventIterator.hasNext()) {
            this.m_event = this.m_eventIterator.next();
        } else {
            this.skipForwardItem();
        }
    }

    private void skipForwardItem() {
        if (this.m_itemIterator.hasNext()) {
            HistogramItem hi = this.m_itemIterator.next();
            this.m_eventIterator = new HistogramIterator(hi, this.m_eventCloud, this.m_gatherFactory);
            this.skipForwardEvent();
        } else {
            this.m_event = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_event != null;
    }

    @Override
    public IEvent next() {
        if (this.hasNext()) {
            IEvent event = this.m_event;
            this.skipForwardEvent();
            return event;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

