/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramIteratorFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramSelectionIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HistogramModel {
    private final Map<Object, HistogramItem> m_histogram = new LinkedHashMap<Object, HistogramItem>();
    private final HistogramColumnDescriptorRepository m_repository;
    private final IEventTypeView m_eventView;
    private GathererFactory m_gatherFactory;
    private int m_maxItems;
    private HistogramItem m_otherItem;
    private boolean m_maxedOut;

    public HistogramModel(HistogramColumnDescriptorRepository repository, IServiceLocator serviceLocator, IEventTypeView eventView) {
        this.m_eventView = eventView;
        this.m_repository = repository;
        this.m_gatherFactory = new GathererFactory(serviceLocator, repository);
        this.m_maxItems = repository.getMaximumCount();
    }

    protected abstract void rebuild();

    protected final ColumnDescriptorRepository getRepository() {
        return this.m_repository;
    }

    public final Iterator<IEvent> createSelectionItertor(IStructuredSelection selection) {
        return new HistogramSelectionIterator(selection, this.getGathererFactory(), this.getEventView());
    }

    protected final IEventTypeView getEventView() {
        return this.m_eventView;
    }

    public final Iterable<IEvent> createHistogramIteratorFactory(IStructuredSelection selection) {
        return new HistogramIteratorFactory(selection, this.getEventView(), this.m_gatherFactory);
    }

    protected final GathererFactory getGathererFactory() {
        return this.m_gatherFactory;
    }

    public final void scheduleRebuild() {
        if (!this.m_repository.getColumnDescriptors().isEmpty()) {
            this.rebuild();
        }
    }

    protected final HistogramItem getHistogramItem(Object key) {
        HistogramItem histogramItem = this.m_histogram.get(key);
        if (histogramItem == null) {
            if (this.m_histogram.size() - 1 == this.m_maxItems || this.m_histogram.size() == this.m_maxItems) {
                if (this.m_otherItem == null) {
                    this.m_otherItem = HistogramItem.createOther(this.m_gatherFactory.createGather());
                    this.m_histogram.put(this.m_otherItem.getKey(), this.m_otherItem);
                    this.setMaxedOut(true);
                }
                histogramItem = this.m_otherItem;
            } else {
                histogramItem = new HistogramItem(key, this.m_gatherFactory.createGather());
                this.m_histogram.put(key, histogramItem);
            }
        }
        return histogramItem;
    }

    private void setMaxedOut(boolean maxedOut) {
        this.m_maxedOut = maxedOut;
    }

    public boolean isMaxedOut() {
        return this.m_maxedOut;
    }

    public final Collection<HistogramItem> getHistogramItems() {
        return this.m_histogram.values();
    }
}

