/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramIterator
implements Iterator<IEvent> {
    private final Iterator<IEvent> m_iterator;
    private final GathererFactory m_gathererFactory;
    private final Object m_key;
    private IEvent m_next;

    HistogramIterator(HistogramItem hi, IEventTypeView cloud, GathererFactory gf) {
        this.m_iterator = cloud.iterator();
        this.m_gathererFactory = gf;
        this.m_key = hi.getKey();
        this.forward();
    }

    private void forward() {
        while (this.m_iterator.hasNext()) {
            Object key;
            IEvent event = this.m_iterator.next();
            RetriverHolder mapper = this.m_gathererFactory.getRetrivers(event.getEventType());
            if (mapper == null || mapper.getGroupBy() == null || (key = mapper.getGroupBy().getValue(event)) == null || !key.equals(this.m_key)) continue;
            this.m_next = event;
            return;
        }
        this.m_next = null;
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public IEvent next() {
        IEvent next = this.m_next;
        this.forward();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

