/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.Gatherer;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;

public final class HistogramItem {
    public static final Object OTHER_KEY = new Object();
    private final Object m_key;
    private Gatherer m_gatherer;
    private Object[] m_values;

    public HistogramItem(Object key, Gatherer gatherer) {
        this.m_key = key;
        this.m_gatherer = gatherer;
    }

    public Object[] getValues() {
        if (this.m_values == null) {
            this.m_values = this.m_gatherer.getValues();
            this.m_gatherer = null;
        }
        return this.m_values;
    }

    public Object getKey() {
        return this.m_key;
    }

    public int hashCode() {
        return this.m_key.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof HistogramItem) {
            return this.m_key.equals(((HistogramItem)object).m_key);
        }
        return false;
    }

    public Object getValue(int index) {
        return this.getValues()[index];
    }

    public void add(RetriverHolder mapper, IEvent event) {
        this.m_gatherer.add(mapper, event);
    }

    public void add(Object[] values) {
        this.m_gatherer.add(values);
    }

    public void setValues(int index, Object value) {
        this.getValues()[index] = value;
    }

    public boolean isOther() {
        return this.m_key == OTHER_KEY;
    }

    public IAggregator[] getAggregators() {
        return this.m_gatherer.getAggregators();
    }

    public static HistogramItem createOther(Gatherer gatherer) {
        return new HistogramItem(OTHER_KEY, gatherer);
    }
}

