/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.util.ImageDescriptorImageProvider;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.layout.SimpleLayoutData;
import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.misc.ui.ColorProvider;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.StringField;
import com.jrockit.mc.core.ui.MCLayoutFactory;
import com.jrockit.mc.core.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.core.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldBackgroundPainter;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.core.ui.fields.PieFieldViewer;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.SelectionIteratorFactory;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewerComponent;
import com.jrockit.mc.flightrecorder.ui.components.fields.ContentTypeField;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItemProvider;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItemSelectionAdapter;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramLabelProvider;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.RetrieverItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.RetriverFilter;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HistogramComponent<M extends HistogramModel>
extends ColumnViewerComponent
implements INavigatorSelectionChangeListener,
ITypeVisibilityChange,
IOperativeSetAware,
IEventConsumer {
    private static final int COMBO_VISIBILITY_COUNT = 15;
    private HistogramItemProvider m_contentProvider;
    private Field m_pieChartField;
    private FieldLabelProvider m_fieldLabelProvider;
    private Composite m_userSelectable;
    private ComboViewer m_comboViewer;
    private EventTypeAcceptor m_acceptor;

    @Override
    public final void initializeUI() {
        if (this.hasUserGroupBy()) {
            this.updateComboContents();
        }
        super.initializeUI();
    }

    @Override
    public final boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            this.m_contentProvider = new HistogramItemProvider();
            this.m_contentProvider.setUserSelectable(this.hasUserGroupBy());
            this.m_acceptor = new EventTypeAcceptor(serviceLocator, this.getTypeRepository());
            return true;
        }
        return false;
    }

    public final boolean dispose(IServiceLocator serviceLocator) {
        this.getModelBuilder().stop();
        return super.dispose(serviceLocator);
    }

    protected Composite createViewerPart(Composite parent, Field[] fields) {
        FormToolkit toolkit = this.getFormToolkit();
        Composite container = toolkit.createComposite(parent, 0);
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        if (this.hasUserGroupBy()) {
            this.m_userSelectable = this.createUserSelectable(toolkit, container);
            this.m_userSelectable.setLayoutData((Object)new GridData(4, 4, true, false));
            if (this.isOperativeSettable()) {
                Button button = this.createOperativeSetButton(container);
                button.setLayoutData((Object)new GridData(4, 4, false, false));
            }
        }
        int columns = Math.max(container.getChildren().length, 1);
        GridData gd = new GridData(4, 4, true, true);
        Composite tablePieChart = this.foo(toolkit, container);
        gd.horizontalSpan = columns;
        tablePieChart.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        container.setLayout((Layout)gl);
        return container;
    }

    private Composite foo(FormToolkit toolkit, Composite parent) {
        Composite viewerContainer = toolkit.createComposite(parent, 0);
        viewerContainer.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SimpleLayout layout = new SimpleLayout();
        layout.setMargin(0);
        viewerContainer.setLayout((Layout)layout);
        Composite tableViewer = null;
        PieFieldViewer pieViewer = null;
        String piePosition = this.getRepository().getPieChartPosition();
        this.m_fieldLabelProvider = this.createLabelProvider(parent.getDisplay());
        if ("west".equals(piePosition) || "north".equals(piePosition)) {
            pieViewer = this.createPieViewer(viewerContainer);
            tableViewer = this.createTable(viewerContainer);
        } else {
            tableViewer = this.createTable(viewerContainer);
            pieViewer = this.createPieViewer(viewerContainer);
        }
        this.setupViewer();
        layout.setHorizontalOrientation("east".equals(piePosition) || "west".equals(piePosition));
        SimpleLayoutData pieData = new SimpleLayoutData();
        pieData.setMaxHorizontalRatio(1.0f);
        pieData.setWeight(1.0f);
        pieData.setVisible(this.getRepository().getShowPieChart() && !CorePlugin.getDefault().getAccessibilityMode());
        pieViewer.getControl().setLayoutData((Object)pieData);
        pieViewer.getControl().addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SimpleLayoutData legendData = new SimpleLayoutData();
        legendData.setWeight(5.0f);
        legendData.setMinSize(this.calculateMinWidth());
        legendData.setVisible(this.getRepository().getShowTable());
        tableViewer.setLayoutData((Object)legendData);
        this.hookModelView((ContentViewer)this.getViewer(), this.getModelBuilder());
        this.hookModelView((ContentViewer)pieViewer, this.getModelBuilder());
        this.hookPieSelectionListener(this.getViewer(), pieViewer);
        this.hookTableSelectionListener(this.getViewer());
        this.hookBackgroundPainter();
        return viewerContainer;
    }

    private FieldLabelProvider createLabelProvider(Display display) {
        if (this.getRepository().getShowPieChart()) {
            return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new ColorProvider(display, 16));
        }
        if (this.getRepository().hasImage()) {
            return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new ImageDescriptorImageProvider(display, this.getRepository().getImageDescriptor()));
        }
        return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new HistogramLabelProvider());
    }

    private void hookBackgroundPainter() {
        if (this.hasNormalizedColumn()) {
            this.hookPainter(this.getRepository().getColumnDescriptors());
        }
    }

    private void hookPainter(final List<ColumnDescriptor> columnDescriptors) {
        TableViewer tw = (TableViewer)this.getViewer();
        tw.getTable().addListener(40, (Listener)new FieldBackgroundPainter(this.getFields(), 1.0, 2){

            protected void drawFieldBackground(Event event, Object element, Object columnElement, Field field) {
                ColumnDescriptor cd = (ColumnDescriptor)columnDescriptors.get(field.INDEX);
                if (cd.getNormalize() && columnElement instanceof Double) {
                    this.drawColumnPercentage(event, (Double)columnElement, new MCColor(200, 100, 100));
                }
            }
        });
    }

    private boolean hasNormalizedColumn() {
        for (ColumnDescriptor cd : this.getRepository().getColumnDescriptors()) {
            if (!cd.getNormalize()) continue;
            return true;
        }
        return false;
    }

    private Composite createTable(Composite viewerContainer) {
        Composite container = this.getFormToolkit().createComposite(viewerContainer, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        if (this.isFilterable()) {
            GridData gd1 = new GridData(4, 4, true, false);
            Composite filterControl = this.createTopControl(container);
            filterControl.setLayoutData((Object)gd1);
        }
        GridData gd2 = new GridData(4, 4, true, true);
        StructuredViewer viewer = this.createViewer(container);
        viewer.getControl().setLayoutData((Object)gd2);
        this.setViewer(viewer);
        return container;
    }

    private int calculateMinWidth() {
        int width = 0;
        for (ColumnDescriptor desc : this.getRepository().getColumnDescriptors()) {
            width += desc.getMinimumWidth();
        }
        return width + this.getRepository().getGroupColumn().getMinimumWidth();
    }

    private Composite createUserSelectable(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        toolkit.paintBordersFor(container);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        Label label = new Label(container, 0);
        label.setText(this.getRepository().getGroupColumn().getName());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Combo combo = this.createCombo(toolkit, container);
        combo.setLayoutData((Object)gd2);
        this.m_comboViewer = this.createComboViewer(combo);
        return container;
    }

    private Combo createCombo(FormToolkit toolkit, Composite parent) {
        Combo combo = new Combo(parent, 65544);
        combo.setVisibleItemCount(15);
        toolkit.adapt((Composite)combo);
        return combo;
    }

    private ComboViewer createComboViewer(Combo combo) {
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setFilters(new ViewerFilter[]{new RetriverFilter()});
        comboViewer.setComparator(this.createComparator());
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RetrieverItem e = (RetrieverItem)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (e != null) {
                    HistogramComponent.this.selectRetriever(e);
                }
            }
        });
        return comboViewer;
    }

    private ViewerComparator createComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object a, Object b) {
                return ((Comparable)a).compareTo((Comparable)b);
            }
        };
    }

    private void hookPieSelectionListener(final StructuredViewer tableViewer, PieFieldViewer pieViewer) {
        pieViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tableViewer.setSelection(event.getSelection(), true);
            }
        });
    }

    @Override
    protected Field findSortedField() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            assert (index < this.getFields().length);
            if (column.isInitialSortColumn()) {
                if (this.hasUserGroupBy()) {
                    return this.getFields()[index + 1];
                }
                return this.getFields()[index];
            }
            ++index;
        }
        return null;
    }

    protected void refreshViewer(ContentViewer viewer) {
        this.updateColors();
        super.refreshViewer(viewer);
        if (viewer instanceof FieldTableViewer && viewer.getSelection().isEmpty()) {
            this.pushSelection((IStructuredSelection)new StructuredSelection());
        }
    }

    private void pushSelection(IStructuredSelection selection) {
        if (selection.getFirstElement() != null) {
            HistogramModel model = (HistogramModel)this.getModelBuilder().getModel();
            Iterable<IEvent> events = model.createHistogramIteratorFactory(selection);
            if (this.getRepository().getRole() == Role.MASTER) {
                for (IEventConsumer ec : this.getComponents().getCompatiblesWithChildren(IEventConsumer.class)) {
                    ec.consumeEvents(events);
                }
            }
            ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setEventFactory(events);
            ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setRange(this.getModelBuilder().getView().getRange());
        } else if (this.getRepository().getRole() == Role.MASTER) {
            for (IEventConsumer ec : this.getComponents().getCompatiblesWithChildren(IEventConsumer.class)) {
                ec.consumeEvents(new SelectionIteratorFactory());
            }
        }
    }

    private void hookTableSelectionListener(StructuredViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HistogramComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void updateColors() {
        ColorProvider colorProvider = this.getColorProvider();
        if (colorProvider != null) {
            colorProvider.invalidate();
            if (this.getRepository().getShowPieChart()) {
                int n = 0;
                ViewModelBuilder builder = this.getModelBuilder();
                Collection<HistogramItem> items = ((HistogramModel)builder.getModel()).getHistogramItems();
                float count = items.size();
                for (HistogramItem item : items) {
                    Color s = this.createColorFromItem(item, (float)n / count);
                    MCColor color = new MCColor(s);
                    colorProvider.registerColor((Object)item, color);
                    ++n;
                }
            }
        }
    }

    private Color createColorFromItem(HistogramItem item, float hue) {
        if (item.isOther()) {
            return Color.LIGHT_GRAY;
        }
        if (item.getKey() instanceof IEventType) {
            return ((IEventType)item.getKey()).getColor();
        }
        if (item.getKey() instanceof IProducer) {
            return ((IProducer)item.getKey()).getColor();
        }
        return Color.getHSBColor(hue, 0.65f, 0.9f);
    }

    private ColorProvider getColorProvider() {
        ILabelProvider labelProvider = this.m_fieldLabelProvider.getSubProvider();
        if (labelProvider instanceof ColorProvider) {
            return (ColorProvider)labelProvider;
        }
        return null;
    }

    public final StructuredViewer createViewer(Composite parent) {
        Table table = this.getFormToolkit().createTable(parent, 268501762);
        FieldTableViewer tableViewer = new FieldTableViewer(table, this.getFields());
        tableViewer.setLabelProvider((IBaseLabelProvider)this.m_fieldLabelProvider);
        tableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        tableViewer.setInput((Object)this.getModelBuilder());
        return tableViewer;
    }

    protected ISelectionProvider getSelectionProvider() {
        return new HistogramItemSelectionAdapter(super.getSelectionProvider());
    }

    @Override
    public final Field[] createFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        if (this.hasUserGroupBy()) {
            ColumnDescriptor cd = this.getRepository().getGroupColumn();
            ContentTypeField field = new ContentTypeField(0);
            EventFieldToolkit.setupField(cd, field);
            EventFieldToolkit.hookColumnField(field, cd);
            field.setVisible(true);
            fields.add(field);
            ++index;
        }
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            Field field = EventFieldToolkit.createField(column, String.valueOf(column.getAttributeIdentifier()) + index, index);
            if (column.isPieChartBy()) {
                this.m_pieChartField = field;
            }
            fields.add(field);
            ++index;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private PieFieldViewer createPieViewer(Composite parent) {
        PieFieldViewer pieViewer = new PieFieldViewer(parent);
        this.getFormToolkit().adapt((Composite)pieViewer.getControl());
        pieViewer.setContentProvider((IContentProvider)this.m_contentProvider);
        pieViewer.setInput((Object)this.getModelBuilder());
        pieViewer.setDataField(this.m_pieChartField);
        pieViewer.setLabelProvider((IBaseLabelProvider)this.m_fieldLabelProvider);
        return pieViewer;
    }

    protected final AbstractFieldTableContentProvider getContentProvider() {
        return this.m_contentProvider;
    }

    @Override
    protected final HistogramColumnDescriptorRepository getRepository() {
        return (HistogramColumnDescriptorRepository)this.getComponentSettings().getChildObject("columnDescriptorRepository", HistogramColumnDescriptorRepository.class);
    }

    @Override
    public final void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
        if (this.hasUserConstrainedEventTypes()) {
            this.markDirty();
        }
    }

    @Override
    public void refresh() {
        if (this.hasUserConstrainedEventTypes()) {
            if (this.hasUserGroupBy()) {
                this.m_acceptor = new EventTypeAcceptor(this.getServiceLocator(), this.getTypeRepository());
                this.updateComboContents();
            } else {
                EventTypeAcceptor a = new EventTypeAcceptor(this.getServiceLocator(), this.getTypeRepository());
                this.getModelBuilder().getView().setEventTypes(a.getAcceptedSet());
            }
        }
        this.getModelBuilder().scheduleRebuild();
    }

    private boolean hasUserGroupBy() {
        return this.getRepository().getUserSelectableGroupBy();
    }

    private boolean hasUserConstrainedEventTypes() {
        return this.getRepository().getEventTypeDescriptorBase().getUserFilterConstrained();
    }

    private void updateComboContents() {
        if (this.hasValidCombo()) {
            RetrieverItem selected = this.getSelectedRetriver();
            this.m_comboViewer.setInput(this.createRetrieverItems(this.m_acceptor));
            if (selected != null) {
                this.m_comboViewer.getControl().setEnabled(true);
                this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
            }
            if (this.getSelectedRetriver() == null) {
                this.m_comboViewer.getCombo().select(0);
                this.selectRetriever(this.getSelectedRetriver());
            }
            this.m_comboViewer.getControl().setEnabled(!this.m_comboViewer.getSelection().isEmpty());
        }
    }

    private List<RetrieverItem> createRetrieverItems(EventTypeAcceptor eta) {
        ArrayList<RetrieverItem> retrievers = new ArrayList<RetrieverItem>();
        for (IEventType type : eta.getAcceptedSet()) {
            for (IRetriever r : type.getRetrivers().values()) {
                retrievers.add(new RetrieverItem(type, r));
            }
        }
        return retrievers;
    }

    private RetrieverItem getSelectedRetriver() {
        if (this.hasValidCombo()) {
            return (RetrieverItem)((IStructuredSelection)this.m_comboViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    private boolean hasValidCombo() {
        return this.m_comboViewer != null && this.m_comboViewer.getControl() != null && !this.m_comboViewer.getControl().isDisposed();
    }

    private EventTypeDescriptorRepository getTypeRepository() {
        return this.getRepository().getEventTypeDescriptorBase();
    }

    private void selectRetriever(RetrieverItem item) {
        if (item == null) {
            ((ContentTypeField)this.getFields()[0]).setContentTypeString("");
            this.getRepository().setGroupByAttribute("");
            if (this.hasUserConstrainedEventTypes()) {
                this.getModelBuilder().getView().setEventTypes(new HashSet());
            }
        } else {
            IRetriever e = item.getRetriever();
            ((ContentTypeField)this.getFields()[0]).setContentTypeString(e.getContentTypeString());
            this.getRepository().setGroupByAttribute(e.getAttributeIdentifier());
            if (this.hasUserConstrainedEventTypes()) {
                this.getModelBuilder().getView().setEventTypes(this.createEventTypeSet(e.getEventTypePath()));
            }
        }
        this.getModelBuilder().scheduleRebuild();
    }

    private Collection<IEventType> createEventTypeSet(String eventTypePath) {
        HashSet<IEventType> types = new HashSet<IEventType>();
        for (IEventType type : this.m_acceptor.getAcceptedSet()) {
            if (!eventTypePath.equals(type.getPath())) continue;
            types.add(type);
        }
        return types;
    }

    static class NoGroupByField
    extends StringField {
        public NoGroupByField(int id) {
            super(id);
        }

        public String formatObject(Object object) {
            return Messages.HISTOGRAM_COMPONENT_NO_VALUE_TO_GROUP_BY_TEXT;
        }
    }
}

