/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ExclusiveDetailInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IntegerInput;
import com.jrockit.mc.components.ui.settings.OrientationInput;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnMasterDetailFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.RepositoryCompatibleAttributeInput;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramColumnMasterDetailFactory
extends ColumnMasterDetailFactory {
    public static final String PIE_CHART_BY = "pieChartBy";

    public HistogramColumnMasterDetailFactory(HistogramColumnDescriptorRepository descriptorRepository, IServiceLocator locator) {
        super(descriptorRepository, locator);
    }

    public List<IInput> createDetailInput() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(this.createPieChart());
        list.add(InputFactory.createEmphasized());
        list.add(InputFactory.createVisible());
        list.add(InputFactory.createFilter(this.getRepository().getColumnDescriptors()));
        list.add(InputFactory.createInitiallySorted(this.getRepository().getColumnDescriptors()));
        list.add(InputFactory.createNormalized());
        list.add(InputFactory.createBackdrop());
        list.add(InputFactory.createAttributeWithStaticRepository(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase(), true));
        list.add((IInput)InputFactory.createName());
        list.add(InputFactory.createDescription());
        list.add(InputFactory.createPreferredSortOrder());
        list.add(InputFactory.createColumnWeightFactor());
        list.add(InputFactory.createMinimumWidth());
        list.add(InputFactory.createAggregator());
        list.add(InputFactory.createUnit(false));
        return list;
    }

    @Override
    protected ColumnDescriptor createColumn(IRetriever descriptor) {
        ColumnDescriptor column = super.createColumn(descriptor);
        if (descriptor.isTextual()) {
            column.setAggregatorIdentifier(AggregatorFactory.FIRST_VALUE.getIdentifier());
        }
        if ("metadata".equals(descriptor.getContentTypeString())) {
            column.setAggregatorIdentifier(AggregatorFactory.FIRST_VALUE.getIdentifier());
        }
        return column;
    }

    public List<IInput> createMainInputs() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(InputFactory.createRole(new Role[0]));
        list.add(this.createShowTable());
        list.add(this.createPieChartPosition());
        list.add(this.createMaximumCount());
        list.add(InputFactory.createOperativeSetEnabled());
        list.add(InputFactory.createIcon());
        return list;
    }

    @Override
    public List<IInput> createSpecific() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(this.createGroupBy(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()));
        list.add(this.createUserSelectable());
        list.add(InputFactory.createColumnWeightFactor());
        list.add(InputFactory.createMinimumWidth());
        list.add(InputFactory.createUnit(false));
        list.add((IInput)InputFactory.createName());
        list.add(InputFactory.createDescription());
        return list;
    }

    private IInput createUserSelectable() {
        return new BooleanInput("userSelectableGroupBy", Messages.HISTOGRAM_CONFIGURATION_ALLOW_USER_CHANGE_INPUT_TEXT);
    }

    protected IInput createGroupBy(IServiceLocator locator, EventTypeDescriptorRepository e) {
        return new RepositoryCompatibleAttributeInput("groupBy", Messages.HISTOGRAM_CONFIGURATION_GROUP_BY_INPUT_TEXT, locator, e, true);
    }

    @Override
    public String createSpecificTitle() {
        return Messages.HISTOGRAM_CONFIGURATION_GROUP_BY_SPECIFIC_TITLE;
    }

    protected IInput createPieChart() {
        return new ExclusiveDetailInput(PIE_CHART_BY, Messages.HISTOGRAM_CONFIGURATION_PIE_CHART_INPUT_TEXT, this.getRepository().getColumnDescriptors());
    }

    protected IInput createMaximumCount() {
        return new IntegerInput("maximumBucketCount", Messages.HISTOGRAM_CONFIGURATION_MAXIMUM_NUMBER_OF_BUCKETS_INPUT_TEXT, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
    }

    protected IInput createPieChartPosition() {
        return new OrientationInput("pieChartPosition", Messages.HISTOGRAM_CONFIGURATION_PIE_CHART_POSITION_INPUT_TEXT);
    }

    protected IInput createShowPieChart() {
        return new BooleanInput("showPieChart", Messages.HISTOGRAM_CONFIGURATION_SHOW_PIE_CHART_INPUT_TEXT);
    }

    protected IInput createShowTable() {
        return new BooleanInput("showTable", Messages.HISTOGRAM_CONFIGURATION_SHOW_TABLE_INPUT_TEXT);
    }
}

