/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import java.util.HashMap;
import java.util.Iterator;

public class VisibilityVisitor
implements IVisitor,
IRangeFilter {
    private final HashMap m_lookup = new HashMap(501);
    private boolean m_showOnlyWorkSet;

    public boolean visit(UIThreadGroup uiThreadGroup) {
        Iterator it = uiThreadGroup.getThreads().iterator();
        while (it.hasNext()) {
            if (!this.visit((UIThread)it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean visit(UIThread uiTHread) {
        Iterator it = uiTHread.getLevelInstances().iterator();
        while (it.hasNext()) {
            if (!this.visit((UILevelInstance)it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean visit(UILevelInstance uiLevellInstance) {
        Boolean b = this.getLookupVisibility(uiLevellInstance);
        if (b == null) {
            boolean v = this.calcLevelVisibility(uiLevellInstance);
            this.setLookupVisibilty(uiLevellInstance, v);
            return v;
        }
        return b;
    }

    public boolean visit(UIGarbageCollector uiGarabage) {
        Iterator it = uiGarabage.getLevelInstances().iterator();
        while (it.hasNext()) {
            if (!this.visit((UILevelInstance)it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean visit(IEvent event) {
        IEventType type = event.getEventType();
        if (type != null && EventToolkit.isVisible(type)) {
            return !this.m_showOnlyWorkSet || EventToolkit.isPartOfOperativeSet(event);
        }
        return false;
    }

    public Boolean getLookupVisibility(Object object) {
        return (Boolean)this.m_lookup.get(object);
    }

    private void setLookupVisibilty(Object o, boolean b) {
        this.m_lookup.put(o, b);
    }

    private boolean calcLevelVisibility(UILevelInstance uiLevellInstance) {
        if (this.m_showOnlyWorkSet) {
            Iterator eventIt = uiLevellInstance.iterator();
            while (eventIt.hasNext()) {
                IEvent event = (IEvent)eventIt.next();
                if (!EventToolkit.isVisible(event.getEventType()) || !EventToolkit.isPartOfOperativeSet(event)) continue;
                return true;
            }
        } else {
            Iterator eventIt = uiLevellInstance.iterator();
            while (eventIt.hasNext()) {
                if (!EventToolkit.isVisible(((IEvent)eventIt.next()).getEventType())) continue;
                return true;
            }
        }
        return false;
    }

    public void setShowOnlyWorkSet(boolean showOnlyWorkSet) {
        this.m_showOnlyWorkSet = showOnlyWorkSet;
    }

    public boolean getShowOnlyWorkSet() {
        return this.m_showOnlyWorkSet;
    }

    public void clearCache() {
        this.m_lookup.clear();
    }

    public final boolean accept(IRange range) {
        return this.visit((IEvent)range);
    }

    public boolean isShowOnlyWorkSet() {
        return this.m_showOnlyWorkSet;
    }
}

