/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.InterpolatedColorFunction;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class UIThreadGroup
implements Visitable {
    private final ArrayList m_threads = new ArrayList();
    private final RenderInfo m_renderInfo = new RenderInfo();
    private final HashMap m_levelHolderMap = new HashMap();
    private String m_name;

    public UIThreadGroup(String name) {
        this.m_name = name == null ? Messages.TRACK_COMPONENT_UNKNOWN_THREAD_GROUP_TEXT : name;
        this.m_renderInfo.setSampler(new CompositeRangeSampler());
        this.m_renderInfo.setColorFunction(new InterpolatedColorFunction(new MCColor(0, 255, 0), new MCColor(255, 0, 0)));
    }

    public void addLevelInstance(UILevelInstance instance) {
        Holder holder = (Holder)this.m_levelHolderMap.get(instance);
        if (holder == null) {
            holder = new Holder();
            holder.renderInfo.setSampler(new CompositeRangeSampler());
            holder.renderInfo.setColorFunction(new InterpolatedColorFunction(new MCColor(255, 255, 255), new MCColor(10, 10, 10)));
            this.m_levelHolderMap.put(instance, holder);
        }
        ((CompositeRangeSampler)holder.renderInfo.getSampleComponent()).add(instance.getRenderInfo().getSampleComponent());
        holder.levelInstances.add(instance);
    }

    public Collection getThreads() {
        return this.m_threads;
    }

    public void addThread(UIThread uit3) {
        this.m_threads.add(uit3);
    }

    public String getName() {
        return this.m_name;
    }

    public RenderInfo getRenderInfo() {
        return this.m_renderInfo;
    }

    public Collection getRenderInfos() {
        ArrayList<RenderInfo> list = new ArrayList<RenderInfo>(this.m_levelHolderMap.values().size());
        for (Holder holder : this.m_levelHolderMap.values()) {
            list.add(holder.renderInfo);
        }
        return list;
    }

    public String toString() {
        return this.getName();
    }

    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    private static class Holder {
        public final RenderInfo renderInfo = new RenderInfo();
        public final ArrayList levelInstances = new ArrayList();

        private Holder() {
        }
    }
}

