/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class UIThread
implements IMCThread,
Visitable {
    private final ArrayList m_levelInstances = new ArrayList();
    private final RenderInfo m_renderInfo = new RenderInfo();
    private final IMCThread m_thread;
    private final IRange m_range;

    public UIThread(IMCThread t) {
        this.m_thread = t;
        this.m_range = t instanceof IRange ? (IRange)t : new Range(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
        this.m_renderInfo.setSampler(new CompositeRangeSampler());
    }

    public void addLevelInstances(Collection uiLevelInstances) {
        this.m_levelInstances.addAll(uiLevelInstances);
        Collections.sort(this.m_levelInstances);
    }

    public Long getThreadId() {
        return this.m_thread.getThreadId();
    }

    public String getThreadName() {
        return this.m_thread.getThreadName();
    }

    public String getThreadState() {
        return this.m_thread.getThreadState();
    }

    public IRange getRange() {
        return this.m_range;
    }

    public Boolean isDeadlocked() {
        return null;
    }

    public RenderInfo getRenderInfo() {
        return this.m_renderInfo;
    }

    public Collection getLevelInstances() {
        return this.m_levelInstances;
    }

    public String toString() {
        return this.getThreadName();
    }

    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    public String getThreadGroup() {
        return this.m_thread.getThreadGroup();
    }
}

